﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include "../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    class AlbumFileLockTable
    {
    public:
        static const int TableSize = FileLockTableSize;

    public:
        AlbumFileLockTable() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // ファイルをロック中にする。
        // 同じファイルを複数回 Lock した場合、同じ回数 Unlock しないと解除されない。
        nn::Result LockFile(const AlbumFileId& fileId) NN_NOEXCEPT;

        // ファイルをアンロックする。
        // 複数回 Lock されている場合、同じ回数 Unlock しないと解除されない。
        // ロックされていないファイルをアンロックしようとした場合、 InternalError。
        nn::Result UnlockFile(const AlbumFileId& fileId) NN_NOEXCEPT;

        // ファイルがロック中かを返す。
        bool IsFileLocked(const AlbumFileId& fileId) const NN_NOEXCEPT;

    public:
        nn::util::optional<AlbumFileId> m_LockedFileList[FileLockTableSize];

    };

}}}}
