﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/capsrv/movie/capsrv_AlbumMovieReadStreamDataSectionAccessor.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_AlbumAccess.h>

namespace nn{ namespace capsrv{ namespace movie{

    nn::Result AlbumMovieReadStreamDataSectionAccessor::Read(size_t* pOutReadSize, void* buffer, size_t size, int64_t offset, void* userData) NN_NOEXCEPT
    {
        auto pSelf = reinterpret_cast<AlbumMovieReadStreamDataSectionAccessor*>(userData);
        return ReadDataFromAlbumMovieReadStream(pOutReadSize, buffer, size, pSelf->handle, offset);
    }

    nn::Result AlbumMovieReadStreamDataSectionAccessor::Write(int64_t offset, const void* buffer, size_t size, void* userData) NN_NOEXCEPT
    {
        NN_UNUSED(offset);
        NN_UNUSED(buffer);
        NN_UNUSED(size);
        NN_UNUSED(userData);
        NN_RESULT_THROW(ResultAlbumDenied());
    }

    nn::Result AlbumMovieReadStreamDataSectionAccessor::Shrink(int64_t size, void* userData) NN_NOEXCEPT
    {
        NN_UNUSED(size);
        NN_UNUSED(userData);
        NN_RESULT_THROW(ResultAlbumDenied());
    }

    MovieStreamAccessor AlbumMovieReadStreamDataSectionAccessor::GetAccessor() NN_NOEXCEPT
    {
        MovieStreamAccessor accessor = {};
        accessor.userData = this;
        accessor.read = Read;
        accessor.write = Write;
        accessor.shrink = Shrink;
        return accessor;
    }

}}}

