﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_ImageBuffer.h"

#include <cstring>
#include <nn/result/result_HandlingUtility.h>

namespace nn{ namespace capsrv{ namespace capture{

    class ImageBufferData
    {
    public:
        typedef ImageBuffer::DataType DataType;
        typedef ImageBuffer::DataStorageType DataStorageType;
        typedef ImageBuffer::InfoType InfoType;
    public:
        static size_t GetRequiredMemorySize(const InfoType& info) NN_NOEXCEPT
        {
            NN_UNUSED(info);
            return 1;
        }

        static size_t GetRequiredMemoryAlignment(CaptureModule* pModule, const InfoType& info) NN_NOEXCEPT
        {
            NN_UNUSED(pModule);
            NN_UNUSED(info);
            return 1;
        }

        nn::Result Initialize(
            CaptureModule* pModule,
            const InfoType& info,
            MemoryPool* pMemoryPool,
            ptrdiff_t offset,
            size_t size
        ) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_Info = info;
            m_pMemoryPool = pMemoryPool;
            m_Offset = offset;
            m_Size = size;
            NN_RESULT_SUCCESS;
        }

        void Finalize() NN_NOEXCEPT
        {
        }

        void FlushCache() const NN_NOEXCEPT
        {
        }

        ImageFormat GetImageFormat() const NN_NOEXCEPT
        {
            return m_Info.format;
        }

        nn::Result WriteToMemory(
            size_t* pOutSize,
            void* pBuffer,
            size_t bufferSize,
            ImageFormat dstFormat,
            const Rectangle* pSrcRectangle
        ) const NN_NOEXCEPT
        {
            NN_UNUSED(dstFormat);
            NN_UNUSED(pSrcRectangle);
            std::memset(pBuffer, 255, bufferSize);
            *pOutSize = bufferSize;
            NN_RESULT_SUCCESS;
        }

    private:
        CaptureModule* m_pModule;
        InfoType       m_Info;
        MemoryPool*    m_pMemoryPool;
        ptrdiff_t      m_Offset;
        size_t         m_Size;
    };

}}}
