﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "capsrv_DisplayCapture.h"

namespace nn{ namespace capsrv{ namespace capture{

    class DisplayCaptureData
    {
    public:
        void Initialize(
            CaptureModule* pModule,
            const char* name,
            nn::vi::LayerStack layerStack,
            int width,
            int height,
            ImageFormat format
            ) NN_NOEXCEPT
        {
            m_pModule = pModule;
            m_Name = name;
            m_LayerStack = layerStack;
            m_Width = width;
            m_Height = height;
            m_Format = format;
            m_pBuffer = nullptr;
        }

        void Finalize() NN_NOEXCEPT
        {
        }

        void SetCaptureBuffer(int index, DisplayBuffer* pBuffer) NN_NOEXCEPT
        {
            NN_UNUSED(index);
            m_pBuffer = pBuffer;
        }

        void UnsetCaptureBuffer(int index) NN_NOEXCEPT
        {
            NN_UNUSED(index);
            m_pBuffer = nullptr;
        }

        DisplayBuffer* AcquireCaptureBuffer(nn::TimeSpan) NN_NOEXCEPT
        {
            return m_pBuffer;
        }

        DisplayBuffer* AcquireCaptureBuffer(nn::TimeSpan, nn::vi::LayerStack) NN_NOEXCEPT
        {
            return m_pBuffer;
        }

        void ReleaseCaptureBuffer(DisplayBuffer* pBuffer) NN_NOEXCEPT
        {
            NN_UNUSED(pBuffer);
        }

        bool IsRecoveryRequired() const NN_NOEXCEPT
        {
            return false;
        }

        bool RecoverCapture(nn::TimeSpan) NN_NOEXCEPT
        {
            return true;
        }

    private:
        CaptureModule*     m_pModule;
        const char*        m_Name;
        nn::vi::LayerStack m_LayerStack;
        int                m_Width;
        int                m_Height;
        ImageFormat        m_Format;
        DisplayBuffer*     m_pBuffer;
    };

}}}

