﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_CaptureModule.h"
#include "capsrv_CaptureModule-module.nvnflinger.h"

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

namespace nn{ namespace capsrv{ namespace capture{

    namespace {
        CaptureModule g_Module;
    }

    CaptureModule::CaptureModule() NN_NOEXCEPT
        : m_Data()
    {
    }

    void CaptureModule::Initialize() NN_NOEXCEPT
    {
        // Initialize nvnflinger
        {
            NN_SDK_REQUIRES(m_Data.pModule == nullptr);
            int result = 0;

            result = hw_get_module(GRALLOC_HARDWARE_MODULE_ID, &m_Data.pModule);
            NN_SDK_ASSERT(result == 0);

            result = gralloc_open(m_Data.pModule, &m_Data.pGralloc);
            NN_SDK_ASSERT(result == 0);

            m_Data.pClient = new android::SurfaceComposerClient();
        }
        // Initialize VIC
        {
            NvError err;
            err = NvRmOpenNew(&m_Data.vicDevice);
            NN_SDK_ASSERT_EQUAL(err, NvSuccess);

            err = NvDdkVicCreateSession(m_Data.vicDevice, nullptr, &m_Data.pVicSession);
            NN_SDK_ASSERT_EQUAL(err, NvSuccess);
        }
    }

    void CaptureModule::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(m_Data.pModule != nullptr);

        // Finalize VIC
        {
            NvDdkVicFreeSession(m_Data.pVicSession);
            NvRmClose(m_Data.vicDevice);
        }

        // Finalize nvnflinger
        {
            m_Data.pClient.clear();
            gralloc_close(m_Data.pGralloc);
            m_Data.pGralloc = nullptr;
            m_Data.pModule = nullptr;
        }
    }



    void InitializeCaptureModule() NN_NOEXCEPT
    {
        g_Module.Initialize();
    }

    void FinalizeCaptureModule() NN_NOEXCEPT
    {
        g_Module.Finalize();
    }

    CaptureModule* GetCaptureModule() NN_NOEXCEPT
    {
        return &g_Module;
    }

}}}
