﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SdkLog.h>

#if defined(__RYNDA__) || (defined(_MSC_VER) && _MSC_VER >= 1900)
#define NN_CAPSRV_CAPTURE_DATASTORAGE_ALIGNMENT_CHECK(type, variable) \
    NN_STATIC_ASSERT(NN_ALIGNOF(type) <= NN_ALIGNOF(variable));
#else // defined(_MSC_VER) && _MSC_VER < 1900
#define NN_CAPSRV_CAPTURE_DATASTORAGE_ALIGNMENT_CHECK(type, variable)
    // VS2012, VS2013 ではコンパイラの内部エラーが発生するのでアライメントチェックしない
#endif

#define NN_CAPSRV_CAPTURE_DATASTORAGE_CHECK(type, variable)         \
    NN_CAPSRV_CAPTURE_DATASTORAGE_ALIGNMENT_CHECK(type, variable);  \
    NN_STATIC_ASSERT(sizeof(type) <= sizeof(variable));


//--------------------------------------------------------
// デバッグログ設定
//--------------------------------------------------------

// NvRmSurface の値を出力する
//#define NN_CAPSRV_CAPTURE_ENABLE_DUMP_SURFACE_PARAMETER

// VicParameter の値を出力する
//#define NN_CAPSRV_CAPTURE_ENABLE_DUMP_VIC_PARAMETER

//--------------------------------------------------------

#if defined(NN_CAPSRV_CAPTURE_ENABLE_DUMP_SURFACE_PARAMETER)
#define NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP(...) NN_SDK_LOG("[capsrv][capture]" __VA_ARGS__)
#else
#define NN_CAPSRV_CAPTURE_LOG_SURFACE_DUMP(...)
#endif

#if defined(NN_CAPSRV_CAPTURE_ENABLE_DUMP_VIC_PARAMETER)
#define NN_CAPSRV_CAPTURE_LOG_VIC_DUMP(...) NN_SDK_LOG("[capsrv][vic]" __VA_ARGS__)
#else
#define NN_CAPSRV_CAPTURE_LOG_VIC_DUMP(...)
#endif

namespace nn{ namespace capsrv{ namespace capture{

    typedef std::aligned_storage< 128, 8>::type MemoryPoolDataStorageType;
    typedef std::aligned_storage<1024, 8>::type DisplayCaptureDataStorageType;
    typedef std::aligned_storage< 512, 8>::type DisplayBufferDataStorageType;
    typedef std::aligned_storage< 256, 8>::type ImageBufferDataStorageType;


}}}
