﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/capsrv/capsrv_AlbumAccess.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace capsrv{

    // Stub ではファイルが存在しないものとして振る舞う

    nn::Result InitializeAlbumAccess() NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    void FinalizeAlbumAccess() NN_NOEXCEPT
    {
    }

    int GetAlbumFileCountLimit(AlbumStorageType storage) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        return 0;
    }

    nn::Result GetAlbumFileCount(
        int* pOutFileCount,
        AlbumStorageType storage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        *pOutFileCount = 0;
        NN_RESULT_SUCCESS;
    }

    nn::Result GetAlbumFileList(
        int* pOutFileCount,
        AlbumEntry* pAlbumEntryBuffer,
        int albumEntryBufferLength,
        AlbumStorageType storage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        *pOutFileCount = 0;
        std::memset(pAlbumEntryBuffer, 0, sizeof(AlbumEntry) * static_cast<size_t>(albumEntryBufferLength));
        NN_RESULT_SUCCESS;
    }

    nn::Result LoadAlbumFile(
        size_t* pOutSize,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutSize = 0;
        std::memset(pBuffer, 0, bufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotFile(
        size_t* pOutSize,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutSize = 0;
        std::memset(pBuffer, 0, bufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumFileThumbnail(
        size_t* pOutSize,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutSize = 0;
        std::memset(pBuffer, 0, bufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotImage(
        int* pOutWidth,
        int* pOutHeight,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotImage(
        int* pOutWidth,
        int* pOutHeight,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotImage(
        int* pOutWidth,
        int* pOutHeight,
        ScreenShotAttribute* pOutAttribute,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pOutAttribute, 0, sizeof(ScreenShotAttribute));
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotImage(
        int* pOutWidth,
        int* pOutHeight,
        ScreenShotAttribute* pOutAttribute,
        AppletData* pOutAppletData,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pOutAttribute, 0, sizeof(ScreenShotAttribute));
        std::memset(pOutAppletData, 0, sizeof(AppletData));
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotThumbnailImage(
        int* pOutWidth,
        int* pOutHeight,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotThumbnailImage(
        int* pOutWidth,
        int* pOutHeight,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotThumbnailImage(
        int* pOutWidth,
        int* pOutHeight,
        ScreenShotAttribute* pOutAttribute,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pOutAttribute, 0, sizeof(ScreenShotAttribute));
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result LoadAlbumScreenShotThumbnailImage(
        int* pOutWidth,
        int* pOutHeight,
        ScreenShotAttribute* pOutAttribute,
        AppletData* pOutAppletData,
        void* pBuffer,
        size_t bufferSize,
        const AlbumFileId* pFileId,
        const ScreenShotDecodeOption& option,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_UNUSED(option);
        *pOutWidth = 0;
        *pOutHeight = 0;
        std::memset(pOutAttribute, 0, sizeof(ScreenShotAttribute));
        std::memset(pOutAppletData, 0, sizeof(AppletData));
        std::memset(pBuffer, 0, bufferSize);
        std::memset(pWorkBuffer, 0, workBufferSize);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result DeleteAlbumFile(
        const AlbumFileId* pFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result StorageCopyAlbumFile(
        const AlbumFileId* pSrcFileId,
        AlbumStorageType destStorage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(pSrcFileId);
        NN_UNUSED(destStorage);
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result GetRequiredStorageFreeSpaceSizeToCopyAll(
        size_t* pOutValue,
        AlbumStorageType dstStorage,
        AlbumStorageType srcStorage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(dstStorage);
        NN_UNUSED(srcStorage);
        *pOutValue = 0;
        NN_RESULT_SUCCESS;
    }

    bool IsAlbumMounted(
        AlbumStorageType storage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        return true;
    }

    nn::Result GetAlbumMountResult(
        AlbumStorageType storage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        NN_RESULT_SUCCESS;
    }

    nn::Result GetAlbumUsage(
        AlbumUsage* pOutValue,
        AlbumStorageType storage
        ) NN_NOEXCEPT
    {
        NN_UNUSED(storage);
        std::memset(pOutValue, 0, sizeof(AlbumUsage));
        NN_RESULT_SUCCESS;
    }

    size_t GetAlbumFileSizeLimit(AlbumFileContentsType contents) NN_NOEXCEPT
    {
        auto sizeLimit = GetAlbumFileSizeLimitImpl(contents);
        NN_ABORT_UNLESS(sizeLimit > 0);
        return static_cast<size_t>(sizeLimit);
    }

    nn::Result GetAlbumFileSize(size_t* pOutValue, const AlbumFileId* pFileId) NN_NOEXCEPT
    {
        NN_UNUSED(pFileId);
        *pOutValue = 0;
        NN_RESULT_THROW(ResultAlbumFileNotFound());
    }

    nn::Result SaveScreenShot(
        ApplicationAlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        ScreenShotSizeType size,
        OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT
    {
        NN_UNUSED(imageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(size);
        NN_UNUSED(overlayRequest);
        *pOutEntry = {};
        NN_RESULT_THROW(ResultAlbumIsFull());
    }

    nn::Result SaveScreenShot(
        ApplicationAlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        const ScreenShotAttribute& attribute,
        OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT
    {
        NN_UNUSED(imageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(attribute);
        NN_UNUSED(overlayRequest);
        *pOutEntry = {};
        NN_RESULT_THROW(ResultAlbumIsFull());
    }

    nn::Result SaveEditedScreenShot(
        AlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        int width,
        int height,
        const void* thumbData,
        size_t thumbDataSize,
        int thumbWidth,
        int thumbHeight,
        const AlbumFileId* pOriginalFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(imageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(width);
        NN_UNUSED(height);
        NN_UNUSED(thumbData);
        NN_UNUSED(thumbDataSize);
        NN_UNUSED(thumbWidth);
        NN_UNUSED(thumbHeight);
        NN_UNUSED(pOriginalFileId);
        *pOutEntry = {};
        NN_RESULT_THROW(ResultAlbumIsFull());
    }

    nn::Result SaveEditedScreenShot(
        AlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        int width,
        int height,
        const void* thumbData,
        size_t thumbDataSize,
        int thumbWidth,
        int thumbHeight,
        const ScreenShotAttribute& attribute,
        const AlbumFileId* pOriginalFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(imageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(width);
        NN_UNUSED(height);
        NN_UNUSED(thumbData);
        NN_UNUSED(thumbDataSize);
        NN_UNUSED(thumbWidth);
        NN_UNUSED(thumbHeight);
        NN_UNUSED(attribute);
        NN_UNUSED(pOriginalFileId);
        *pOutEntry = {};
        NN_RESULT_THROW(ResultAlbumIsFull());
    }

    nn::Result SaveEditedScreenShot(
        AlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        int width,
        int height,
        const void* thumbData,
        size_t thumbDataSize,
        int thumbWidth,
        int thumbHeight,
        const ScreenShotAttribute& attribute,
        const AppletData& appletData,
        const AlbumFileId* pOriginalFileId
        ) NN_NOEXCEPT
    {
        NN_UNUSED(imageData);
        NN_UNUSED(imageDataSize);
        NN_UNUSED(width);
        NN_UNUSED(height);
        NN_UNUSED(thumbData);
        NN_UNUSED(thumbDataSize);
        NN_UNUSED(thumbWidth);
        NN_UNUSED(thumbHeight);
        NN_UNUSED(attribute);
        NN_UNUSED(appletData);
        NN_UNUSED(pOriginalFileId);
        *pOutEntry = {};
        NN_RESULT_THROW(ResultAlbumIsFull());
    }

    nn::Result GetLastThumbnail(
        AlbumFileId* pOutFileId,
        size_t* pOutDataSize,
        void* pOutBuffer,
        size_t bufferSize
        ) NN_NOEXCEPT
    {
        *pOutFileId = {};
        *pOutDataSize = ThumbnailImageDataSize_Default;
        std::memset(pOutBuffer, 0xFF, bufferSize);
        NN_RESULT_SUCCESS;
    }

    nn::Result GetLastOverlayScreenShotThumbnail(
        AlbumFileId* pOutFileId,
        size_t* pOutDataSize,
        void* pOutBuffer,
        size_t bufferSize
        ) NN_NOEXCEPT
    {
        *pOutFileId = {};
        *pOutDataSize = ThumbnailImageDataSize_Default;
        std::memset(pOutBuffer, 0xFF, bufferSize);
        NN_RESULT_SUCCESS;
    }

    nn::Result GetLastOverlayMovieThumbnail(
        AlbumFileId* pOutFileId,
        size_t* pOutDataSize,
        void* pOutBuffer,
        size_t bufferSize
        ) NN_NOEXCEPT
    {
        *pOutFileId = {};
        *pOutDataSize = ThumbnailImageDataSize_Default;
        std::memset(pOutBuffer, 0xFF, bufferSize);
        NN_RESULT_SUCCESS;
    }

    nn::Result GetAutoSavingStorage(
        AlbumStorageType* pOutValue
        ) NN_NOEXCEPT
    {
        *pOutValue = AlbumStorage_Nand;
        NN_RESULT_SUCCESS;
    }

    nn::Result GetAlbumEntryFromApplicationAlbumEntry(AlbumEntry* pOutValue, const ApplicationAlbumEntry& entry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    {
        NN_UNUSED(entry);
        NN_UNUSED(applicationId);
        *pOutValue = {};
        NN_RESULT_SUCCESS;
    }

    nn::Result OpenAlbumMovieReadStream(AlbumMovieReadStreamHandle* pOutHandle, const AlbumFileId& fileId) NN_NOEXCEPT
    {
        NN_UNUSED(fileId);
        *pOutHandle = {};
        NN_RESULT_THROW(ResultAlbumFileNotFound()); // FileNotFound
    }

    void CloseAlbumMovieReadStream(AlbumMovieReadStreamHandle handle) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
    }

    nn::Result GetAlbumMovieReadStreamDataSize(int64_t* pOutSize, AlbumMovieReadStreamHandle handle) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
        *pOutSize = 0;
        NN_RESULT_THROW(ResultAlbumNotFound()); // HandleNotFound
    }

    nn::Result ReadDataFromAlbumMovieReadStream(size_t* pOutReadSize, void* buffer, size_t size, AlbumMovieReadStreamHandle handle, int64_t offset) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
        NN_UNUSED(offset);
        *pOutReadSize = 0;
        std::memset(buffer, 0, size);
        NN_RESULT_THROW(ResultAlbumNotFound()); // HandleNotFound
    }

    nn::Result GetAlbumMovieReadStreamImageDataSize(int64_t* pOutSize, AlbumMovieReadStreamHandle handle) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
        *pOutSize = 0;
        NN_RESULT_THROW(ResultAlbumNotFound()); // HandleNotFound
    }

    nn::Result ReadImageDataFromAlbumMovieReadStream(size_t* pOutReadSize, void* buffer, size_t size, AlbumMovieReadStreamHandle handle, int64_t offset) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
        NN_UNUSED(offset);
        *pOutReadSize = 0;
        std::memset(buffer, 0, size);
        NN_RESULT_THROW(ResultAlbumNotFound()); // HandleNotFound
    }
    nn::Result GetAlbumMovieReadStreamBrokenReason(AlbumMovieReadStreamHandle handle) NN_NOEXCEPT
    {
        NN_UNUSED(handle);
        NN_RESULT_THROW(ResultAlbumNotFound()); // HandleNotFound
    }

}}
