﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/album/album_ShareId.h>

namespace nn{ namespace album{

    struct SharedIdInternal
    {
        char serviceName[16];
        char entryId[256];
        char _reserved[512 - 16 - 256];
        char lastUrl[512];
    };

    NN_STATIC_ASSERT(sizeof(SharedIdInternal) == sizeof(ShareId));

}}
