﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/album/album_GetSharePostedService.h>
#include <nn/album/album_GetSharePostedLastUrl.h>

#include <algorithm>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>

#include "album_ShareIdInternal.h"

namespace nn{ namespace album{

    int GetSharePostedServiceName(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
        NN_SDK_REQUIRES_GREATER(bufferSize, 0u);

        auto p = reinterpret_cast<const SharedIdInternal*>(&shareId);
        auto maxSize = std::min<int>(bufferSize, SharePostedServiceNameSizeMax);

        nn::util::Strlcpy(pOutBuffer, p->serviceName, maxSize);
        return nn::util::Strnlen(pOutBuffer, bufferSize);
    }

    int GetSharePostedEntryId(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
        NN_SDK_REQUIRES_GREATER(bufferSize, 0u);

        auto p = reinterpret_cast<const SharedIdInternal*>(&shareId);
        auto maxSize = std::min<int>(bufferSize, SharePostedEntryIdSizeMax);

        nn::util::Strlcpy(pOutBuffer, p->entryId, maxSize);
        return nn::util::Strnlen(pOutBuffer, bufferSize);
    }

    int GetSharePostedLastUrl(char* pOutBuffer, size_t bufferSize, const ShareId& shareId) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
        NN_SDK_REQUIRES_GREATER(bufferSize, 0u);

        auto p = reinterpret_cast<const SharedIdInternal*>(&shareId);
        auto maxSize = std::min<int>(bufferSize, SharePostedLastUrlSizeMax);

        nn::util::Strlcpy(pOutBuffer, p->lastUrl, maxSize);
        return nn::util::Strnlen(pOutBuffer, bufferSize);
    }
}}
