﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

namespace nn{ namespace album{

    class LibraryState
    {
    public:
        LibraryState() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;
        bool IsAlbumAvailable() const NN_NOEXCEPT;
        bool IsShareAvailable() const NN_NOEXCEPT;

        // nn::album 全体で使う Mutex 。
        // @pre IsInitialized
        nn::os::SdkRecursiveMutexType* GetLibraryMutex() NN_NOEXCEPT;

        // @post IsAlbumAvailable
        void EnsureAlbumAvailable() NN_NOEXCEPT;

        // @post IsShareAvailable
        void EnsureShareAvailable() NN_NOEXCEPT;

    private:
        int m_InitializeCount;
        bool m_IsAlbumAvailable;
        bool m_IsShareAvailable;

        nn::os::SdkRecursiveMutexType m_LibraryMutex;
    };

    extern LibraryState g_LibraryState;

}}
