﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/os/argument.h>
#include <cstdlib>
#include <winext/cafe/os.h>

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
  Name:         GetArgc

  Description:  Get number of valid arguments.
                This function is for debug.

  Arguments:    None

  Returns:      number of valid arguments.
                return 1 if no argument.
 *---------------------------------------------------------------------------*/
int
GetArgc()
{
    return __argc;
}


/*---------------------------------------------------------------------------*
  Name:         GetArgv

  Description:  Get the pointer to the specified argument string.
                This function is for debug.

  Arguments:    n : index of argument. n==1 means the first argument.
                    n must less than value of OS_GetArgc()

  Returns:      pointer to the specified argument string
 *---------------------------------------------------------------------------*/
const char*
GetArgv(int n)
{
    //ASSERT(n < __argc);
    return __argv[n];
}

}   // namespace winext
}   // namespace internal
}   // namespace nw
