﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <Windows.h>
#include <winext/cafe.h>

#include <winext/cafe/os/OSThread.h>

namespace nw {
namespace internal {
namespace winext {

    static DWORD WINAPI ThreadFunc(
        LPVOID lpParameter   // スレッドのデータ
        )
    {
        OSThread* thread = reinterpret_cast<OSThread*>(lpParameter);

        return thread->func( thread->intArg, thread->ptrArg );
    }

BOOL OSCreateThread(
    OSThread*  thread ,
    OSThread_Proc entryPoint,
    int        intArg,
    void*      ptrArg,
    void*      stack,
    u32        stackSize ,
    OSPriority priority,
    u16        attr
    )
{
    thread->handle = CreateThread(
        NULL,
        0,
        ThreadFunc,
        thread,
        CREATE_SUSPENDED,
        NULL
    );
    if ( thread->handle == NULL )
    {
        return FALSE;
    }

    if ( priority < 16 )
    {
        SetThreadPriority( thread->handle, THREAD_PRIORITY_HIGHEST );
    }

    thread->intArg = intArg;
    thread->ptrArg = ptrArg;
    thread->func = entryPoint;

    return TRUE;
}

BOOL OSJoinThread (OSThread* thread, int* val)
{
    WaitForSingleObject( thread->handle, INFINITE );

    if ( val != NULL )
    {
    DWORD dwExitCode;
    GetExitCodeThread( thread->handle, &dwExitCode );
    *val = dwExitCode;
    }

    return TRUE;
}

s32 OSResumeThread (OSThread* thread)
{
    ResumeThread( thread->handle );

    return 0;
}

void OSSleepMilliseconds(u32 msec)
{
    Sleep(msec);
}

} // namespace winext
} // namespace internal
} // namespace nw

