﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/os.h>
#include <winext/cafe/ax.h>
#include <winext/cafe/axfx.h>
#include "AXFXPrivate.h"

namespace nw {
    namespace internal {
        namespace winext {


static f32 __SrcTab12khz[128*4] =
{
        (1.0f/32768.0f)*(f32)((s16)0x0C7B),
        (1.0f/32768.0f)*(f32)((s16)0x66AF),
        (1.0f/32768.0f)*(f32)((s16)0x0D01),
        (1.0f/32768.0f)*(f32)((s16)0xFFE0),
        (1.0f/32768.0f)*(f32)((s16)0x0BF8),
        (1.0f/32768.0f)*(f32)((s16)0x66A9),
        (1.0f/32768.0f)*(f32)((s16)0x0D8B),
        (1.0f/32768.0f)*(f32)((s16)0xFFDE),
        (1.0f/32768.0f)*(f32)((s16)0x0B78),
        (1.0f/32768.0f)*(f32)((s16)0x669E),
        (1.0f/32768.0f)*(f32)((s16)0x0E18),
        (1.0f/32768.0f)*(f32)((s16)0xFFDA),
        (1.0f/32768.0f)*(f32)((s16)0x0AFB),
        (1.0f/32768.0f)*(f32)((s16)0x668D),
        (1.0f/32768.0f)*(f32)((s16)0x0EA7),
        (1.0f/32768.0f)*(f32)((s16)0xFFD6),
        (1.0f/32768.0f)*(f32)((s16)0x0A80),
        (1.0f/32768.0f)*(f32)((s16)0x6676),
        (1.0f/32768.0f)*(f32)((s16)0x0F39),
        (1.0f/32768.0f)*(f32)((s16)0xFFD2),
        (1.0f/32768.0f)*(f32)((s16)0x0A08),
        (1.0f/32768.0f)*(f32)((s16)0x665A),
        (1.0f/32768.0f)*(f32)((s16)0x0FCE),
        (1.0f/32768.0f)*(f32)((s16)0xFFCE),
        (1.0f/32768.0f)*(f32)((s16)0x0993),
        (1.0f/32768.0f)*(f32)((s16)0x6639),
        (1.0f/32768.0f)*(f32)((s16)0x1067),
        (1.0f/32768.0f)*(f32)((s16)0xFFCA),
        (1.0f/32768.0f)*(f32)((s16)0x0922),
        (1.0f/32768.0f)*(f32)((s16)0x6612),
        (1.0f/32768.0f)*(f32)((s16)0x1102),
        (1.0f/32768.0f)*(f32)((s16)0xFFC6),
        (1.0f/32768.0f)*(f32)((s16)0x08B3),
        (1.0f/32768.0f)*(f32)((s16)0x65E5),
        (1.0f/32768.0f)*(f32)((s16)0x11A0),
        (1.0f/32768.0f)*(f32)((s16)0xFFC1),
        (1.0f/32768.0f)*(f32)((s16)0x0848),
        (1.0f/32768.0f)*(f32)((s16)0x65B3),
        (1.0f/32768.0f)*(f32)((s16)0x1241),
        (1.0f/32768.0f)*(f32)((s16)0xFFBD),
        (1.0f/32768.0f)*(f32)((s16)0x07DF),
        (1.0f/32768.0f)*(f32)((s16)0x657C),
        (1.0f/32768.0f)*(f32)((s16)0x12E5),
        (1.0f/32768.0f)*(f32)((s16)0xFFB8),
        (1.0f/32768.0f)*(f32)((s16)0x0778),
        (1.0f/32768.0f)*(f32)((s16)0x653F),
        (1.0f/32768.0f)*(f32)((s16)0x138C),
        (1.0f/32768.0f)*(f32)((s16)0xFFB4),
        (1.0f/32768.0f)*(f32)((s16)0x0715),
        (1.0f/32768.0f)*(f32)((s16)0x64FC),
        (1.0f/32768.0f)*(f32)((s16)0x1436),
        (1.0f/32768.0f)*(f32)((s16)0xFFAF),
        (1.0f/32768.0f)*(f32)((s16)0x06B4),
        (1.0f/32768.0f)*(f32)((s16)0x64B4),
        (1.0f/32768.0f)*(f32)((s16)0x14E3),
        (1.0f/32768.0f)*(f32)((s16)0xFFA9),
        (1.0f/32768.0f)*(f32)((s16)0x0656),
        (1.0f/32768.0f)*(f32)((s16)0x6468),
        (1.0f/32768.0f)*(f32)((s16)0x1592),
        (1.0f/32768.0f)*(f32)((s16)0xFFA4),
        (1.0f/32768.0f)*(f32)((s16)0x05FB),
        (1.0f/32768.0f)*(f32)((s16)0x6415),
        (1.0f/32768.0f)*(f32)((s16)0x1645),
        (1.0f/32768.0f)*(f32)((s16)0xFF9E),
        (1.0f/32768.0f)*(f32)((s16)0x05A2),
        (1.0f/32768.0f)*(f32)((s16)0x63BD),
        (1.0f/32768.0f)*(f32)((s16)0x16FA),
        (1.0f/32768.0f)*(f32)((s16)0xFF99),
        (1.0f/32768.0f)*(f32)((s16)0x054D),
        (1.0f/32768.0f)*(f32)((s16)0x6360),
        (1.0f/32768.0f)*(f32)((s16)0x17B2),
        (1.0f/32768.0f)*(f32)((s16)0xFF93),
        (1.0f/32768.0f)*(f32)((s16)0x04FA),
        (1.0f/32768.0f)*(f32)((s16)0x62FE),
        (1.0f/32768.0f)*(f32)((s16)0x186D),
        (1.0f/32768.0f)*(f32)((s16)0xFF8D),
        (1.0f/32768.0f)*(f32)((s16)0x04A9),
        (1.0f/32768.0f)*(f32)((s16)0x6297),
        (1.0f/32768.0f)*(f32)((s16)0x192A),
        (1.0f/32768.0f)*(f32)((s16)0xFF87),
        (1.0f/32768.0f)*(f32)((s16)0x045B),
        (1.0f/32768.0f)*(f32)((s16)0x622B),
        (1.0f/32768.0f)*(f32)((s16)0x19EB),
        (1.0f/32768.0f)*(f32)((s16)0xFF81),
        (1.0f/32768.0f)*(f32)((s16)0x0410),
        (1.0f/32768.0f)*(f32)((s16)0x61BA),
        (1.0f/32768.0f)*(f32)((s16)0x1AAE),
        (1.0f/32768.0f)*(f32)((s16)0xFF7B),
        (1.0f/32768.0f)*(f32)((s16)0x03C7),
        (1.0f/32768.0f)*(f32)((s16)0x6143),
        (1.0f/32768.0f)*(f32)((s16)0x1B73),
        (1.0f/32768.0f)*(f32)((s16)0xFF74),
        (1.0f/32768.0f)*(f32)((s16)0x0381),
        (1.0f/32768.0f)*(f32)((s16)0x60C8),
        (1.0f/32768.0f)*(f32)((s16)0x1C3B),
        (1.0f/32768.0f)*(f32)((s16)0xFF6E),
        (1.0f/32768.0f)*(f32)((s16)0x033D),
        (1.0f/32768.0f)*(f32)((s16)0x6048),
        (1.0f/32768.0f)*(f32)((s16)0x1D06),
        (1.0f/32768.0f)*(f32)((s16)0xFF67),
        (1.0f/32768.0f)*(f32)((s16)0x02FC),
        (1.0f/32768.0f)*(f32)((s16)0x5FC4),
        (1.0f/32768.0f)*(f32)((s16)0x1DD3),
        (1.0f/32768.0f)*(f32)((s16)0xFF61),
        (1.0f/32768.0f)*(f32)((s16)0x02BD),
        (1.0f/32768.0f)*(f32)((s16)0x5F3B),
        (1.0f/32768.0f)*(f32)((s16)0x1EA2),
        (1.0f/32768.0f)*(f32)((s16)0xFF5A),
        (1.0f/32768.0f)*(f32)((s16)0x0281),
        (1.0f/32768.0f)*(f32)((s16)0x5EAD),
        (1.0f/32768.0f)*(f32)((s16)0x1F74),
        (1.0f/32768.0f)*(f32)((s16)0xFF52),
        (1.0f/32768.0f)*(f32)((s16)0x0247),
        (1.0f/32768.0f)*(f32)((s16)0x5E1B),
        (1.0f/32768.0f)*(f32)((s16)0x2048),
        (1.0f/32768.0f)*(f32)((s16)0xFF4B),
        (1.0f/32768.0f)*(f32)((s16)0x020E),
        (1.0f/32768.0f)*(f32)((s16)0x5D84),
        (1.0f/32768.0f)*(f32)((s16)0x211E),
        (1.0f/32768.0f)*(f32)((s16)0xFF45),
        (1.0f/32768.0f)*(f32)((s16)0x01D8),
        (1.0f/32768.0f)*(f32)((s16)0x5CE9),
        (1.0f/32768.0f)*(f32)((s16)0x21F7),
        (1.0f/32768.0f)*(f32)((s16)0xFF3E),
        (1.0f/32768.0f)*(f32)((s16)0x01A4),
        (1.0f/32768.0f)*(f32)((s16)0x5C4A),
        (1.0f/32768.0f)*(f32)((s16)0x22D2),
        (1.0f/32768.0f)*(f32)((s16)0xFF36),
        (1.0f/32768.0f)*(f32)((s16)0x0173),
        (1.0f/32768.0f)*(f32)((s16)0x5BA6),
        (1.0f/32768.0f)*(f32)((s16)0x23AF),
        (1.0f/32768.0f)*(f32)((s16)0xFF2F),
        (1.0f/32768.0f)*(f32)((s16)0x0144),
        (1.0f/32768.0f)*(f32)((s16)0x5AFF),
        (1.0f/32768.0f)*(f32)((s16)0x248E),
        (1.0f/32768.0f)*(f32)((s16)0xFF29),
        (1.0f/32768.0f)*(f32)((s16)0x0117),
        (1.0f/32768.0f)*(f32)((s16)0x5A53),
        (1.0f/32768.0f)*(f32)((s16)0x256F),
        (1.0f/32768.0f)*(f32)((s16)0xFF22),
        (1.0f/32768.0f)*(f32)((s16)0x00EC),
        (1.0f/32768.0f)*(f32)((s16)0x59A4),
        (1.0f/32768.0f)*(f32)((s16)0x2651),
        (1.0f/32768.0f)*(f32)((s16)0xFF1A),
        (1.0f/32768.0f)*(f32)((s16)0x00C2),
        (1.0f/32768.0f)*(f32)((s16)0x58F1),
        (1.0f/32768.0f)*(f32)((s16)0x2736),
        (1.0f/32768.0f)*(f32)((s16)0xFF13),
        (1.0f/32768.0f)*(f32)((s16)0x009A),
        (1.0f/32768.0f)*(f32)((s16)0x583A),
        (1.0f/32768.0f)*(f32)((s16)0x281D),
        (1.0f/32768.0f)*(f32)((s16)0xFF0D),
        (1.0f/32768.0f)*(f32)((s16)0x0075),
        (1.0f/32768.0f)*(f32)((s16)0x577F),
        (1.0f/32768.0f)*(f32)((s16)0x2905),
        (1.0f/32768.0f)*(f32)((s16)0xFF06),
        (1.0f/32768.0f)*(f32)((s16)0x0051),
        (1.0f/32768.0f)*(f32)((s16)0x56C0),
        (1.0f/32768.0f)*(f32)((s16)0x29EF),
        (1.0f/32768.0f)*(f32)((s16)0xFEFE),
        (1.0f/32768.0f)*(f32)((s16)0x002F),
        (1.0f/32768.0f)*(f32)((s16)0x55FF),
        (1.0f/32768.0f)*(f32)((s16)0x2ADA),
        (1.0f/32768.0f)*(f32)((s16)0xFEF7),
        (1.0f/32768.0f)*(f32)((s16)0x000F),
        (1.0f/32768.0f)*(f32)((s16)0x553A),
        (1.0f/32768.0f)*(f32)((s16)0x2BC6),
        (1.0f/32768.0f)*(f32)((s16)0xFEF1),
        (1.0f/32768.0f)*(f32)((s16)0xFFF0),
        (1.0f/32768.0f)*(f32)((s16)0x5472),
        (1.0f/32768.0f)*(f32)((s16)0x2CB4),
        (1.0f/32768.0f)*(f32)((s16)0xFEEB),
        (1.0f/32768.0f)*(f32)((s16)0xFFD4),
        (1.0f/32768.0f)*(f32)((s16)0x53A7),
        (1.0f/32768.0f)*(f32)((s16)0x2DA4),
        (1.0f/32768.0f)*(f32)((s16)0xFEE5),
        (1.0f/32768.0f)*(f32)((s16)0xFFB9),
        (1.0f/32768.0f)*(f32)((s16)0x52D8),
        (1.0f/32768.0f)*(f32)((s16)0x2E94),
        (1.0f/32768.0f)*(f32)((s16)0xFEDE),
        (1.0f/32768.0f)*(f32)((s16)0xFF9F),
        (1.0f/32768.0f)*(f32)((s16)0x5207),
        (1.0f/32768.0f)*(f32)((s16)0x2F86),
        (1.0f/32768.0f)*(f32)((s16)0xFED8),
        (1.0f/32768.0f)*(f32)((s16)0xFF87),
        (1.0f/32768.0f)*(f32)((s16)0x5132),
        (1.0f/32768.0f)*(f32)((s16)0x3079),
        (1.0f/32768.0f)*(f32)((s16)0xFED2),
        (1.0f/32768.0f)*(f32)((s16)0xFF71),
        (1.0f/32768.0f)*(f32)((s16)0x505B),
        (1.0f/32768.0f)*(f32)((s16)0x316D),
        (1.0f/32768.0f)*(f32)((s16)0xFECE),
        (1.0f/32768.0f)*(f32)((s16)0xFF5D),
        (1.0f/32768.0f)*(f32)((s16)0x4F82),
        (1.0f/32768.0f)*(f32)((s16)0x3262),
        (1.0f/32768.0f)*(f32)((s16)0xFEC9),
        (1.0f/32768.0f)*(f32)((s16)0xFF49),
        (1.0f/32768.0f)*(f32)((s16)0x4EA6),
        (1.0f/32768.0f)*(f32)((s16)0x3357),
        (1.0f/32768.0f)*(f32)((s16)0xFEC4),
        (1.0f/32768.0f)*(f32)((s16)0xFF37),
        (1.0f/32768.0f)*(f32)((s16)0x4DC7),
        (1.0f/32768.0f)*(f32)((s16)0x344D),
        (1.0f/32768.0f)*(f32)((s16)0xFEBF),
        (1.0f/32768.0f)*(f32)((s16)0xFF26),
        (1.0f/32768.0f)*(f32)((s16)0x4CE6),
        (1.0f/32768.0f)*(f32)((s16)0x3543),
        (1.0f/32768.0f)*(f32)((s16)0xFEBB),
        (1.0f/32768.0f)*(f32)((s16)0xFF16),
        (1.0f/32768.0f)*(f32)((s16)0x4C03),
        (1.0f/32768.0f)*(f32)((s16)0x363A),
        (1.0f/32768.0f)*(f32)((s16)0xFEB8),
        (1.0f/32768.0f)*(f32)((s16)0xFF08),
        (1.0f/32768.0f)*(f32)((s16)0x4B1E),
        (1.0f/32768.0f)*(f32)((s16)0x3732),
        (1.0f/32768.0f)*(f32)((s16)0xFEB4),
        (1.0f/32768.0f)*(f32)((s16)0xFEFB),
        (1.0f/32768.0f)*(f32)((s16)0x4A36),
        (1.0f/32768.0f)*(f32)((s16)0x3829),
        (1.0f/32768.0f)*(f32)((s16)0xFEB1),
        (1.0f/32768.0f)*(f32)((s16)0xFEEF),
        (1.0f/32768.0f)*(f32)((s16)0x494D),
        (1.0f/32768.0f)*(f32)((s16)0x3921),
        (1.0f/32768.0f)*(f32)((s16)0xFEAF),
        (1.0f/32768.0f)*(f32)((s16)0xFEE4),
        (1.0f/32768.0f)*(f32)((s16)0x4863),
        (1.0f/32768.0f)*(f32)((s16)0x3A19),
        (1.0f/32768.0f)*(f32)((s16)0xFEAD),
        (1.0f/32768.0f)*(f32)((s16)0xFEDA),
        (1.0f/32768.0f)*(f32)((s16)0x4777),
        (1.0f/32768.0f)*(f32)((s16)0x3B11),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0xFED2),
        (1.0f/32768.0f)*(f32)((s16)0x4689),
        (1.0f/32768.0f)*(f32)((s16)0x3C09),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0xFECA),
        (1.0f/32768.0f)*(f32)((s16)0x4599),
        (1.0f/32768.0f)*(f32)((s16)0x3D01),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0xFEC3),
        (1.0f/32768.0f)*(f32)((s16)0x44A9),
        (1.0f/32768.0f)*(f32)((s16)0x3DF8),
        (1.0f/32768.0f)*(f32)((s16)0xFEAC),
        (1.0f/32768.0f)*(f32)((s16)0xFEBD),
        (1.0f/32768.0f)*(f32)((s16)0x43B7),
        (1.0f/32768.0f)*(f32)((s16)0x3EEF),
        (1.0f/32768.0f)*(f32)((s16)0xFEAC),
        (1.0f/32768.0f)*(f32)((s16)0xFEB8),
        (1.0f/32768.0f)*(f32)((s16)0x42C4),
        (1.0f/32768.0f)*(f32)((s16)0x3FE5),
        (1.0f/32768.0f)*(f32)((s16)0xFEAE),
        (1.0f/32768.0f)*(f32)((s16)0xFEB4),
        (1.0f/32768.0f)*(f32)((s16)0x41D0),
        (1.0f/32768.0f)*(f32)((s16)0x40DB),
        (1.0f/32768.0f)*(f32)((s16)0xFEB0),
        (1.0f/32768.0f)*(f32)((s16)0xFEB0),
        (1.0f/32768.0f)*(f32)((s16)0x40DB),
        (1.0f/32768.0f)*(f32)((s16)0x41D0),
        (1.0f/32768.0f)*(f32)((s16)0xFEB4),
        (1.0f/32768.0f)*(f32)((s16)0xFEAE),
        (1.0f/32768.0f)*(f32)((s16)0x3FE5),
        (1.0f/32768.0f)*(f32)((s16)0x42C4),
        (1.0f/32768.0f)*(f32)((s16)0xFEB8),
        (1.0f/32768.0f)*(f32)((s16)0xFEAC),
        (1.0f/32768.0f)*(f32)((s16)0x3EEF),
        (1.0f/32768.0f)*(f32)((s16)0x43B7),
        (1.0f/32768.0f)*(f32)((s16)0xFEBD),
        (1.0f/32768.0f)*(f32)((s16)0xFEAC),
        (1.0f/32768.0f)*(f32)((s16)0x3DF8),
        (1.0f/32768.0f)*(f32)((s16)0x44A9),
        (1.0f/32768.0f)*(f32)((s16)0xFEC3),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0x3D01),
        (1.0f/32768.0f)*(f32)((s16)0x4599),
        (1.0f/32768.0f)*(f32)((s16)0xFECA),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0x3C09),
        (1.0f/32768.0f)*(f32)((s16)0x4689),
        (1.0f/32768.0f)*(f32)((s16)0xFED2),
        (1.0f/32768.0f)*(f32)((s16)0xFEAB),
        (1.0f/32768.0f)*(f32)((s16)0x3B11),
        (1.0f/32768.0f)*(f32)((s16)0x4777),
        (1.0f/32768.0f)*(f32)((s16)0xFEDA),
        (1.0f/32768.0f)*(f32)((s16)0xFEAD),
        (1.0f/32768.0f)*(f32)((s16)0x3A19),
        (1.0f/32768.0f)*(f32)((s16)0x4863),
        (1.0f/32768.0f)*(f32)((s16)0xFEE4),
        (1.0f/32768.0f)*(f32)((s16)0xFEAF),
        (1.0f/32768.0f)*(f32)((s16)0x3921),
        (1.0f/32768.0f)*(f32)((s16)0x494D),
        (1.0f/32768.0f)*(f32)((s16)0xFEEF),
        (1.0f/32768.0f)*(f32)((s16)0xFEB1),
        (1.0f/32768.0f)*(f32)((s16)0x3829),
        (1.0f/32768.0f)*(f32)((s16)0x4A36),
        (1.0f/32768.0f)*(f32)((s16)0xFEFB),
        (1.0f/32768.0f)*(f32)((s16)0xFEB4),
        (1.0f/32768.0f)*(f32)((s16)0x3732),
        (1.0f/32768.0f)*(f32)((s16)0x4B1E),
        (1.0f/32768.0f)*(f32)((s16)0xFF08),
        (1.0f/32768.0f)*(f32)((s16)0xFEB8),
        (1.0f/32768.0f)*(f32)((s16)0x363A),
        (1.0f/32768.0f)*(f32)((s16)0x4C03),
        (1.0f/32768.0f)*(f32)((s16)0xFF16),
        (1.0f/32768.0f)*(f32)((s16)0xFEBB),
        (1.0f/32768.0f)*(f32)((s16)0x3543),
        (1.0f/32768.0f)*(f32)((s16)0x4CE6),
        (1.0f/32768.0f)*(f32)((s16)0xFF26),
        (1.0f/32768.0f)*(f32)((s16)0xFEBF),
        (1.0f/32768.0f)*(f32)((s16)0x344D),
        (1.0f/32768.0f)*(f32)((s16)0x4DC7),
        (1.0f/32768.0f)*(f32)((s16)0xFF37),
        (1.0f/32768.0f)*(f32)((s16)0xFEC4),
        (1.0f/32768.0f)*(f32)((s16)0x3357),
        (1.0f/32768.0f)*(f32)((s16)0x4EA6),
        (1.0f/32768.0f)*(f32)((s16)0xFF49),
        (1.0f/32768.0f)*(f32)((s16)0xFEC9),
        (1.0f/32768.0f)*(f32)((s16)0x3262),
        (1.0f/32768.0f)*(f32)((s16)0x4F82),
        (1.0f/32768.0f)*(f32)((s16)0xFF5D),
        (1.0f/32768.0f)*(f32)((s16)0xFECE),
        (1.0f/32768.0f)*(f32)((s16)0x316D),
        (1.0f/32768.0f)*(f32)((s16)0x505B),
        (1.0f/32768.0f)*(f32)((s16)0xFF71),
        (1.0f/32768.0f)*(f32)((s16)0xFED2),
        (1.0f/32768.0f)*(f32)((s16)0x3079),
        (1.0f/32768.0f)*(f32)((s16)0x5132),
        (1.0f/32768.0f)*(f32)((s16)0xFF87),
        (1.0f/32768.0f)*(f32)((s16)0xFED8),
        (1.0f/32768.0f)*(f32)((s16)0x2F86),
        (1.0f/32768.0f)*(f32)((s16)0x5207),
        (1.0f/32768.0f)*(f32)((s16)0xFF9F),
        (1.0f/32768.0f)*(f32)((s16)0xFEDE),
        (1.0f/32768.0f)*(f32)((s16)0x2E94),
        (1.0f/32768.0f)*(f32)((s16)0x52D8),
        (1.0f/32768.0f)*(f32)((s16)0xFFB9),
        (1.0f/32768.0f)*(f32)((s16)0xFEE5),
        (1.0f/32768.0f)*(f32)((s16)0x2DA4),
        (1.0f/32768.0f)*(f32)((s16)0x53A7),
        (1.0f/32768.0f)*(f32)((s16)0xFFD4),
        (1.0f/32768.0f)*(f32)((s16)0xFEEB),
        (1.0f/32768.0f)*(f32)((s16)0x2CB4),
        (1.0f/32768.0f)*(f32)((s16)0x5472),
        (1.0f/32768.0f)*(f32)((s16)0xFFF0),
        (1.0f/32768.0f)*(f32)((s16)0xFEF1),
        (1.0f/32768.0f)*(f32)((s16)0x2BC6),
        (1.0f/32768.0f)*(f32)((s16)0x553A),
        (1.0f/32768.0f)*(f32)((s16)0x000F),
        (1.0f/32768.0f)*(f32)((s16)0xFEF7),
        (1.0f/32768.0f)*(f32)((s16)0x2ADA),
        (1.0f/32768.0f)*(f32)((s16)0x55FF),
        (1.0f/32768.0f)*(f32)((s16)0x002F),
        (1.0f/32768.0f)*(f32)((s16)0xFEFE),
        (1.0f/32768.0f)*(f32)((s16)0x29EF),
        (1.0f/32768.0f)*(f32)((s16)0x56C0),
        (1.0f/32768.0f)*(f32)((s16)0x0051),
        (1.0f/32768.0f)*(f32)((s16)0xFF06),
        (1.0f/32768.0f)*(f32)((s16)0x2905),
        (1.0f/32768.0f)*(f32)((s16)0x577F),
        (1.0f/32768.0f)*(f32)((s16)0x0075),
        (1.0f/32768.0f)*(f32)((s16)0xFF0D),
        (1.0f/32768.0f)*(f32)((s16)0x281D),
        (1.0f/32768.0f)*(f32)((s16)0x583A),
        (1.0f/32768.0f)*(f32)((s16)0x009A),
        (1.0f/32768.0f)*(f32)((s16)0xFF13),
        (1.0f/32768.0f)*(f32)((s16)0x2736),
        (1.0f/32768.0f)*(f32)((s16)0x58F1),
        (1.0f/32768.0f)*(f32)((s16)0x00C2),
        (1.0f/32768.0f)*(f32)((s16)0xFF1A),
        (1.0f/32768.0f)*(f32)((s16)0x2651),
        (1.0f/32768.0f)*(f32)((s16)0x59A4),
        (1.0f/32768.0f)*(f32)((s16)0x00EC),
        (1.0f/32768.0f)*(f32)((s16)0xFF22),
        (1.0f/32768.0f)*(f32)((s16)0x256F),
        (1.0f/32768.0f)*(f32)((s16)0x5A53),
        (1.0f/32768.0f)*(f32)((s16)0x0117),
        (1.0f/32768.0f)*(f32)((s16)0xFF29),
        (1.0f/32768.0f)*(f32)((s16)0x248E),
        (1.0f/32768.0f)*(f32)((s16)0x5AFF),
        (1.0f/32768.0f)*(f32)((s16)0x0144),
        (1.0f/32768.0f)*(f32)((s16)0xFF2F),
        (1.0f/32768.0f)*(f32)((s16)0x23AF),
        (1.0f/32768.0f)*(f32)((s16)0x5BA6),
        (1.0f/32768.0f)*(f32)((s16)0x0173),
        (1.0f/32768.0f)*(f32)((s16)0xFF36),
        (1.0f/32768.0f)*(f32)((s16)0x22D2),
        (1.0f/32768.0f)*(f32)((s16)0x5C4A),
        (1.0f/32768.0f)*(f32)((s16)0x01A4),
        (1.0f/32768.0f)*(f32)((s16)0xFF3E),
        (1.0f/32768.0f)*(f32)((s16)0x21F7),
        (1.0f/32768.0f)*(f32)((s16)0x5CE9),
        (1.0f/32768.0f)*(f32)((s16)0x01D8),
        (1.0f/32768.0f)*(f32)((s16)0xFF45),
        (1.0f/32768.0f)*(f32)((s16)0x211E),
        (1.0f/32768.0f)*(f32)((s16)0x5D84),
        (1.0f/32768.0f)*(f32)((s16)0x020E),
        (1.0f/32768.0f)*(f32)((s16)0xFF4B),
        (1.0f/32768.0f)*(f32)((s16)0x2048),
        (1.0f/32768.0f)*(f32)((s16)0x5E1B),
        (1.0f/32768.0f)*(f32)((s16)0x0247),
        (1.0f/32768.0f)*(f32)((s16)0xFF52),
        (1.0f/32768.0f)*(f32)((s16)0x1F74),
        (1.0f/32768.0f)*(f32)((s16)0x5EAD),
        (1.0f/32768.0f)*(f32)((s16)0x0281),
        (1.0f/32768.0f)*(f32)((s16)0xFF5A),
        (1.0f/32768.0f)*(f32)((s16)0x1EA2),
        (1.0f/32768.0f)*(f32)((s16)0x5F3B),
        (1.0f/32768.0f)*(f32)((s16)0x02BD),
        (1.0f/32768.0f)*(f32)((s16)0xFF61),
        (1.0f/32768.0f)*(f32)((s16)0x1DD3),
        (1.0f/32768.0f)*(f32)((s16)0x5FC4),
        (1.0f/32768.0f)*(f32)((s16)0x02FC),
        (1.0f/32768.0f)*(f32)((s16)0xFF67),
        (1.0f/32768.0f)*(f32)((s16)0x1D06),
        (1.0f/32768.0f)*(f32)((s16)0x6048),
        (1.0f/32768.0f)*(f32)((s16)0x033D),
        (1.0f/32768.0f)*(f32)((s16)0xFF6E),
        (1.0f/32768.0f)*(f32)((s16)0x1C3B),
        (1.0f/32768.0f)*(f32)((s16)0x60C8),
        (1.0f/32768.0f)*(f32)((s16)0x0381),
        (1.0f/32768.0f)*(f32)((s16)0xFF74),
        (1.0f/32768.0f)*(f32)((s16)0x1B73),
        (1.0f/32768.0f)*(f32)((s16)0x6143),
        (1.0f/32768.0f)*(f32)((s16)0x03C7),
        (1.0f/32768.0f)*(f32)((s16)0xFF7B),
        (1.0f/32768.0f)*(f32)((s16)0x1AAE),
        (1.0f/32768.0f)*(f32)((s16)0x61BA),
        (1.0f/32768.0f)*(f32)((s16)0x0410),
        (1.0f/32768.0f)*(f32)((s16)0xFF81),
        (1.0f/32768.0f)*(f32)((s16)0x19EB),
        (1.0f/32768.0f)*(f32)((s16)0x622B),
        (1.0f/32768.0f)*(f32)((s16)0x045B),
        (1.0f/32768.0f)*(f32)((s16)0xFF87),
        (1.0f/32768.0f)*(f32)((s16)0x192A),
        (1.0f/32768.0f)*(f32)((s16)0x6297),
        (1.0f/32768.0f)*(f32)((s16)0x04A9),
        (1.0f/32768.0f)*(f32)((s16)0xFF8D),
        (1.0f/32768.0f)*(f32)((s16)0x186D),
        (1.0f/32768.0f)*(f32)((s16)0x62FE),
        (1.0f/32768.0f)*(f32)((s16)0x04FA),
        (1.0f/32768.0f)*(f32)((s16)0xFF93),
        (1.0f/32768.0f)*(f32)((s16)0x17B2),
        (1.0f/32768.0f)*(f32)((s16)0x6360),
        (1.0f/32768.0f)*(f32)((s16)0x054D),
        (1.0f/32768.0f)*(f32)((s16)0xFF99),
        (1.0f/32768.0f)*(f32)((s16)0x16FA),
        (1.0f/32768.0f)*(f32)((s16)0x63BD),
        (1.0f/32768.0f)*(f32)((s16)0x05A2),
        (1.0f/32768.0f)*(f32)((s16)0xFF9E),
        (1.0f/32768.0f)*(f32)((s16)0x1645),
        (1.0f/32768.0f)*(f32)((s16)0x6415),
        (1.0f/32768.0f)*(f32)((s16)0x05FB),
        (1.0f/32768.0f)*(f32)((s16)0xFFA4),
        (1.0f/32768.0f)*(f32)((s16)0x1592),
        (1.0f/32768.0f)*(f32)((s16)0x6468),
        (1.0f/32768.0f)*(f32)((s16)0x0656),
        (1.0f/32768.0f)*(f32)((s16)0xFFA9),
        (1.0f/32768.0f)*(f32)((s16)0x14E3),
        (1.0f/32768.0f)*(f32)((s16)0x64B4),
        (1.0f/32768.0f)*(f32)((s16)0x06B4),
        (1.0f/32768.0f)*(f32)((s16)0xFFAF),
        (1.0f/32768.0f)*(f32)((s16)0x1436),
        (1.0f/32768.0f)*(f32)((s16)0x64FC),
        (1.0f/32768.0f)*(f32)((s16)0x0715),
        (1.0f/32768.0f)*(f32)((s16)0xFFB4),
        (1.0f/32768.0f)*(f32)((s16)0x138C),
        (1.0f/32768.0f)*(f32)((s16)0x653F),
        (1.0f/32768.0f)*(f32)((s16)0x0778),
        (1.0f/32768.0f)*(f32)((s16)0xFFB8),
        (1.0f/32768.0f)*(f32)((s16)0x12E5),
        (1.0f/32768.0f)*(f32)((s16)0x657C),
        (1.0f/32768.0f)*(f32)((s16)0x07DF),
        (1.0f/32768.0f)*(f32)((s16)0xFFBD),
        (1.0f/32768.0f)*(f32)((s16)0x1241),
        (1.0f/32768.0f)*(f32)((s16)0x65B3),
        (1.0f/32768.0f)*(f32)((s16)0x0848),
        (1.0f/32768.0f)*(f32)((s16)0xFFC1),
        (1.0f/32768.0f)*(f32)((s16)0x11A0),
        (1.0f/32768.0f)*(f32)((s16)0x65E5),
        (1.0f/32768.0f)*(f32)((s16)0x08B3),
        (1.0f/32768.0f)*(f32)((s16)0xFFC6),
        (1.0f/32768.0f)*(f32)((s16)0x1102),
        (1.0f/32768.0f)*(f32)((s16)0x6612),
        (1.0f/32768.0f)*(f32)((s16)0x0922),
        (1.0f/32768.0f)*(f32)((s16)0xFFCA),
        (1.0f/32768.0f)*(f32)((s16)0x1067),
        (1.0f/32768.0f)*(f32)((s16)0x6639),
        (1.0f/32768.0f)*(f32)((s16)0x0993),
        (1.0f/32768.0f)*(f32)((s16)0xFFCE),
        (1.0f/32768.0f)*(f32)((s16)0x0FCE),
        (1.0f/32768.0f)*(f32)((s16)0x665A),
        (1.0f/32768.0f)*(f32)((s16)0x0A08),
        (1.0f/32768.0f)*(f32)((s16)0xFFD2),
        (1.0f/32768.0f)*(f32)((s16)0x0F39),
        (1.0f/32768.0f)*(f32)((s16)0x6676),
        (1.0f/32768.0f)*(f32)((s16)0x0A80),
        (1.0f/32768.0f)*(f32)((s16)0xFFD6),
        (1.0f/32768.0f)*(f32)((s16)0x0EA7),
        (1.0f/32768.0f)*(f32)((s16)0x668D),
        (1.0f/32768.0f)*(f32)((s16)0x0AFB),
        (1.0f/32768.0f)*(f32)((s16)0xFFDA),
        (1.0f/32768.0f)*(f32)((s16)0x0E18),
        (1.0f/32768.0f)*(f32)((s16)0x669E),
        (1.0f/32768.0f)*(f32)((s16)0x0B78),
        (1.0f/32768.0f)*(f32)((s16)0xFFDE),
        (1.0f/32768.0f)*(f32)((s16)0x0D8B),
        (1.0f/32768.0f)*(f32)((s16)0x66A9),
        (1.0f/32768.0f)*(f32)((s16)0x0BF8),
        (1.0f/32768.0f)*(f32)((s16)0xFFE0),
        (1.0f/32768.0f)*(f32)((s16)0x0D01),
        (1.0f/32768.0f)*(f32)((s16)0x66AF),
        (1.0f/32768.0f)*(f32)((s16)0x0C7B)
    };



f32* __AXFXGetSrcCoef(u32 setNum)
{
    return __SrcTab12khz + (4 * setNum);
}

        } // namespace winext
    } // namespace internal
} // namespace nw
