﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/os.h>
#include <winext/cafe/ax.h>
#include <winext/cafe/axfx.h>
#include "AXFXPrivate.h"

namespace nw {
    namespace internal {
        namespace winext {


//
// sin ( 0.f - PI(rad ) : Fixed Point version
//
// NOTE : 0xII.DDDDDD
//
static s32 __SinTableFixedPoint[128] =
{
        0x00000000,  // 0.000000f
        0x00064855,  // 0.024541f
        0x000c8fb3,  // 0.049068f
        0x0012d520,  // 0.073565f
        0x001917a6,  // 0.098017f
        0x001f564e,  // 0.122411f
        0x00259020,  // 0.146730f
        0x002bc428,  // 0.170962f
        0x0031f170,  // 0.195090f
        0x00381704,  // 0.219101f
        0x003e33f3,  // 0.242980f
        0x0044474a,  // 0.266713f
        0x004a5018,  // 0.290285f
        0x00504d72,  // 0.313682f
        0x00563e6a,  // 0.336890f
        0x005c2215,  // 0.359895f
        0x0061f78b,  // 0.382683f
        0x0067bde5,  // 0.405241f
        0x006d7440,  // 0.427555f
        0x007319ba,  // 0.449611f
        0x0078ad75,  // 0.471397f
        0x007e2e94,  // 0.492898f
        0x00839c3d,  // 0.514103f
        0x0088f59b,  // 0.534998f
        0x008e39da,  // 0.555570f
        0x0093682b,  // 0.575808f
        0x00987fc0,  // 0.595699f
        0x009d7fd2,  // 0.615232f
        0x00a2679a,  // 0.634393f
        0x00a73656,  // 0.653173f
        0x00abeb4a,  // 0.671559f
        0x00b085bb,  // 0.689541f
        0x00b504f3,  // 0.707107f
        0x00b96842,  // 0.724247f
        0x00bdaefa,  // 0.740951f
        0x00c1d871,  // 0.757209f
        0x00c5e403,  // 0.773010f
        0x00c9d112,  // 0.788346f
        0x00cd9f02,  // 0.803208f
        0x00d14d3d,  // 0.817585f
        0x00d4db32,  // 0.831470f
        0x00d84853,  // 0.844854f
        0x00db941b,  // 0.857729f
        0x00debe05,  // 0.870087f
        0x00e1c598,  // 0.881921f
        0x00e4aa59,  // 0.893224f
        0x00e76bd8,  // 0.903989f
        0x00ea09a7,  // 0.914210f
        0x00ec835e,  // 0.923880f
        0x00eed89e,  // 0.932993f
        0x00f10908,  // 0.941544f
        0x00f31448,  // 0.949528f
        0x00f4fa0b,  // 0.956940f
        0x00f6ba07,  // 0.963776f
        0x00f853f8,  // 0.970031f
        0x00f9c79d,  // 0.975702f
        0x00fb14bf,  // 0.980785f
        0x00fc3b28,  // 0.985278f
        0x00fd3aac,  // 0.989177f
        0x00fe1324,  // 0.992480f
        0x00fec46d,  // 0.995185f
        0x00ff4e6d,  // 0.997290f
        0x00ffb10f,  // 0.998795f
        0x00ffec43,  // 0.999699f
        0x01000000,  // 1.000000f
        0x00ffec43,  // 0.999699f
        0x00ffb10f,  // 0.998795f
        0x00ff4e6d,  // 0.997290f
        0x00fec46d,  // 0.995185f
        0x00fe1323,  // 0.992480f
        0x00fd3aac,  // 0.989177f
        0x00fc3b28,  // 0.985278f
        0x00fb14be,  // 0.980785f
        0x00f9c79d,  // 0.975702f
        0x00f853f8,  // 0.970031f
        0x00f6ba07,  // 0.963776f
        0x00f4fa0a,  // 0.956940f
        0x00f31447,  // 0.949528f
        0x00f10908,  // 0.941544f
        0x00eed89e,  // 0.932993f
        0x00ec835e,  // 0.923880f
        0x00ea09a6,  // 0.914210f
        0x00e76bd8,  // 0.903989f
        0x00e4aa59,  // 0.893224f
        0x00e1c597,  // 0.881921f
        0x00debe06,  // 0.870087f
        0x00db941a,  // 0.857729f
        0x00d84852,  // 0.844854f
        0x00d4db30,  // 0.831470f
        0x00d14d3d,  // 0.817585f
        0x00cd9f02,  // 0.803208f
        0x00c9d111,  // 0.788346f
        0x00c5e404,  // 0.773010f
        0x00c1d870,  // 0.757209f
        0x00bdaef8,  // 0.740951f
        0x00b96840,  // 0.724247f
        0x00b504f3,  // 0.707107f
        0x00b085ba,  // 0.689541f
        0x00abeb48,  // 0.671559f
        0x00a73656,  // 0.653173f
        0x00a26799,  // 0.634393f
        0x009d7fd0,  // 0.615232f
        0x00987fbd,  // 0.595699f
        0x0093682a,  // 0.575808f
        0x008e39d9,  // 0.555570f
        0x0088f598,  // 0.534997f
        0x00839c3d,  // 0.514103f
        0x007e2e92,  // 0.492898f
        0x0078ad73,  // 0.471397f
        0x007319bb,  // 0.449611f
        0x006d743f,  // 0.427555f
        0x0067bde3,  // 0.405241f
        0x0061f788,  // 0.382683f
        0x005c2215,  // 0.359895f
        0x00563e69,  // 0.336890f
        0x00504d70,  // 0.313682f
        0x004a5019,  // 0.290285f
        0x00444749,  // 0.266713f
        0x003e33f1,  // 0.242980f
        0x00381702,  // 0.219101f
        0x0031f170,  // 0.195090f
        0x002bc427,  // 0.170962f
        0x0025901e,  // 0.146730f
        0x001f564e,  // 0.122411f
        0x001917a6,  // 0.098017f
        0x0012d51e,  // 0.073564f
        0x000c8faf,  // 0.049067f
        0x00064855   // 0.024541f

};



//
// gets LFO table
//
s32* __AXFXGetLfoSinTable(void)
{
    return __SinTableFixedPoint;
}

        } // namespace winext
    } // namespace internal
} // namespace nw
