﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stdio.h>
#include <cstdarg>
#include <wctype.h>
#include <nw/ut/ut_SafeString.h>

namespace nw {
namespace ut {

//------------------------------------------------------------------------------

template<>
s32 BufferedSafeStringBase<char>::formatImpl_( char* dst, s32 dst_size, const char* format_string, va_list varg )
{
    return nw::ut::vsnprintf( dst, dst_size, format_string, varg );
}

//------------------------------------------------------------------------------

template<>
s32 BufferedSafeStringBase<char16>::formatImpl_( char16* dst, s32 dst_size, const char16* format_string, va_list varg )
{
    return nw::ut::vsnw16printf( dst, dst_size, dst_size - 1, format_string, varg );
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char>::formatV( const char* format_string, va_list varg )
{
    char* mutable_string_top = getMutableStringTop_();
    return formatImpl_( mutable_string_top, getBufferSize(), format_string, varg );
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char16>::formatV( const char16* format_string, va_list varg )
{
    char16* mutable_string_top = getMutableStringTop_();
    return formatImpl_( mutable_string_top, getBufferSize(), format_string, varg );
}

//------------------------------------------------------------------------------
template<>
BufferedSafeStringBase<char>& BufferedSafeStringBase<char>::format( const char* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    (void)formatV( format_string, va );
    va_end( va );
    return *this;
}

//------------------------------------------------------------------------------
template<>
BufferedSafeStringBase<char16>& BufferedSafeStringBase<char16>::format( const char16* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    (void)formatV( format_string, va );
    va_end( va );
    return *this;
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char>::appendWithFormatV( const char* format_string, va_list varg )
{
    char* mutable_string_top = getMutableStringTop_();
    s32 length = calcLength();
    s32 ret = formatImpl_( mutable_string_top + length, getBufferSize() - length, format_string, varg );
    return length + ret;
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char16>::appendWithFormatV( const char16* format_string, va_list varg )
{
    char16* mutable_string_top = getMutableStringTop_();
    s32 length = calcLength();
    s32 ret = formatImpl_( mutable_string_top + length, getBufferSize() - length, format_string, varg );
    return length + ret;
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char>::appendWithFormat( const char* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    s32 ret = appendWithFormatV( format_string, va );
    va_end( va );
    return ret;
}

//------------------------------------------------------------------------------
template<>
s32 BufferedSafeStringBase<char16>::appendWithFormat( const char16* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    s32 ret = appendWithFormatV( format_string, va );
    va_end( va );
    return ret;
}

//------------------------------------------------------------------------------
template<>
FixedSafeStringBase<char>& FixedSafeStringBase<char>::format( const char* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    (void)formatV( format_string, va );
    va_end( va );
    return *this;
}

//------------------------------------------------------------------------------
template<>
FixedSafeStringBase<char16>& FixedSafeStringBase<char16>::format( const char16* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    (void)formatV( format_string, va );
    va_end( va );
    return *this;
}

//------------------------------------------------------------------------------
template<>
s32 FixedSafeStringBase<char>::appendWithFormat( const char* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    s32 ret = appendWithFormatV( format_string, va );
    va_end( va );
    return ret;
}

//------------------------------------------------------------------------------
template<>
s32 FixedSafeStringBase<char16>::appendWithFormat( const char16* format_string, ... )
{
    va_list va;
    va_start( va, format_string );
    s32 ret = appendWithFormatV( format_string, va );
    va_end( va );
    return ret;
}

//------------------------------------------------------------------------------
} /* namespace ut */
} /* namespace nw */
