﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <nw/ut/ut_Inlines.h>
#include <nw/ut/ut_MemoryAllocator.h>
#include <stdlib.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/mem/expHeap.h>
#else
  #include <winext/cafe/mem/expHeap.h>
#endif


namespace nw {
namespace ut {

//--------------------------------------------------------------------------
void
MemoryAllocator::Initialize(void* startAddress, size_t size, u16 option)
{
#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    using namespace nw::internal::winext;
#elif defined( NW_PLATFORM_ANDROID ) || defined(NW_PLATFORM_IOS)
    using namespace nw::internal::winext;
#endif

    m_HeapHandle = MEMCreateExpHeapEx(startAddress, size, option);
}

//--------------------------------------------------------------------------
void
MemoryAllocator::Finalize()
{
    MEMDestroyExpHeap(m_HeapHandle);
}

//--------------------------------------------------------------------------
size_t
MemoryAllocator::GetFreeSize()
{
    return MEMGetTotalFreeSizeForExpHeap(m_HeapHandle);
}

//--------------------------------------------------------------------------
size_t
MemoryAllocator::GetTotalSize()
{
    return MEMGetHeapTotalSize(m_HeapHandle);
}

//--------------------------------------------------------------------------
size_t
MemoryAllocator::GetMemoryBlockSize(void* address)
{
#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    using namespace nw::internal::winext;
#elif defined( NW_PLATFORM_ANDROID ) || defined(NW_PLATFORM_IOS)
    using namespace nw::internal::winext;
#endif

    return MEMGetSizeForMBlockExpHeap(address);
}

//--------------------------------------------------------------------------
void
MemoryAllocator::Dump()
{
    MEMDumpHeap(m_HeapHandle);
}

} /* namespace ut */
} /* namespace nw   */
