﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/math.h>

#include <nw/math/math_Vector4.h>

#if !defined(NW_MATH_AS_INLINE)
#include <nw/math/inline/math_Vector4.ipp>
#endif

namespace nw { namespace math {

/* ------------------------------------------------------------------------
        VEC4
   ------------------------------------------------------------------------ */

/*!--------------------------------------------------------------------------*
  Name:         VEC4::Report

  @brief        ベクトルの内容をデバッグ出力に書き出します。

  @param[in]    bNewline  true なら出力の最後に改行を出力します。
  @param[in]    name      ベクトルの名前を指定します。NULL指定可能です。

  @return       なし
 *---------------------------------------------------------------------------*/
void
VEC4::Report(bool bNewline, const char* name) const
{
    if (name)
        NW_MATH_REPORT("%s", name);
    else
        NW_MATH_REPORT("VEC4");

    NW_MATH_REPORT("<%f, %f, %f, %f>", x, y, z, w);
    if (bNewline)
        NW_MATH_REPORT("\n");
}

}  // namespace math
}  // namespace nw
