﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/window/dw_ControlWindow.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------

ControlWindow::ControlWindow() :
m_pRootElement(NULL),
m_Measurement(MEASUREMENT_MANUAL)
{
}

ControlWindow::~ControlWindow()
{
}

//---------------------------------------------------------------------------

UIElement*
ControlWindow::GetContent() const
{
    return m_pRootElement;
}

void
ControlWindow::SetContent(UIElement* pContent)
{
    if(m_pRootElement != NULL)
    {
        DeactivateContent();
    }

    m_pRootElement = pContent;

    if(m_pRootElement != NULL)
    {
        ActivateContent();

        if(IsCreated())
        {
            StretchContent();
        }
    }
}

Measurement
ControlWindow::GetMeasurement() const
{
    return m_Measurement;
}

void
ControlWindow::SetMeasurement(Measurement value)
{
    m_Measurement = value;
}

bool
ControlWindow::OnCreate()
{
    if(!Base::OnCreate())
    {
        return false;
    }

    if(m_pRootElement != NULL)
    {
        StretchContent();
    }

    return true;
}

void
ControlWindow::OnSize()
{
    if(m_pRootElement == NULL)
    {
        return;
    }

    StretchContent();
}

void
ControlWindow::OnUpdateInputs(const nw::internal::dw::Inputs& inputs)
{
    if(m_pRootElement == NULL)
    {
        return;
    }

    const nw::ut::Rect clientRect = GetClientRect();

    m_pRootElement->UpdateInputs(
        Inputs(inputs).SetPointerPosition(
            inputs.GetPointerPosition().x - clientRect.left,
            inputs.GetPointerPosition().y - clientRect.top));
}

void
ControlWindow::OnUpdate(UIRenderer& renderer)
{
    if(m_pRootElement == NULL)
    {
        return;
    }

    bool isAutoSize = m_Measurement != MEASUREMENT_MANUAL;

    if(isAutoSize)
    {
        m_pRootElement->SetMeasurement(m_Measurement);

        nw::math::Vector2 size(GetClientSize());
        nw::math::Vector2 measuredSize = m_pRootElement->Measure(renderer);

        if(m_Measurement & MEASUREMENT_AUTO_WIDTH)
        {
            size.x = measuredSize.x + m_pRootElement->GetMargin().GetWidth();
        }

        if(m_Measurement & MEASUREMENT_AUTO_HEIGHT)
        {
            size.y = measuredSize.y + m_pRootElement->GetMargin().GetHeight();
        }

        SetSizeFromClientSize(size);
    }

    m_pRootElement->Update(m_UIElementContext, renderer, !isAutoSize);
}

void
ControlWindow::OnDraw(IUIRenderContext& context, UIRenderer& renderer)
{
    (void)context;

    if(m_pRootElement == NULL)
    {
        return;
    }

    m_pRootElement->Render(m_UIElementContext, renderer);
}

void
ControlWindow::ActivateContent()
{
    NW_NULL_ASSERT(m_pRootElement);
    m_pRootElement->SetFocus();
}

void
ControlWindow::DeactivateContent()
{
    NW_NULL_ASSERT(m_pRootElement);
    // ★TODO : 非アクティブ化
}

void
ControlWindow::StretchContent()
{
    NW_NULL_ASSERT(m_pRootElement);

    nw::math::Vector2 size = GetClientSize();
    nw::internal::dw::Thickness margin = m_pRootElement->GetMargin();

    size.x -= margin.GetWidth();
    size.y -= margin.GetHeight();

    m_pRootElement->SetTopLeft(margin.left, margin.top);
    m_pRootElement->SetSize(size);
}

} // namespace nw::internal::dw
} // namespace nw::internal
} // namespace nw

