﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_Pointer.h>
#include <nw/assert.h>
#include <nw/gfnd/gfnd_Graphics.h>

namespace nw {
namespace internal {
namespace dw {
namespace detail {

//---------------------------------------------------------------------------
Pointer::Pointer()
 : m_Allocator( NULL )
 , m_Type( nw::dev::POINTER_ARROW )
 , m_TexImage( NULL )
 , m_IsIntialized( false )
{}

//---------------------------------------------------------------------------
Pointer::~Pointer()
{
}

//---------------------------------------------------------------------------
void
Pointer::Initialize( nw::ut::IAllocator* allocator )
{
    m_Allocator = allocator;

    nw::gfnd::Graphics::GetInstance()->LockDrawContext();
    {
    #if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
        // TODO: NintendoSdk 対応後、このコメントを削除してください。
        m_TexImage = nw::dev::CreatePointerTexture( allocator, nw::dev::POINTER_ARROW, &m_Texture );
    #else
        m_TexImage = nw::dev::CreatePointerTexture( allocator, nw::dev::POINTER_ARROW, &m_Texture, &m_TextureArrow );
    #endif
    }
    nw::gfnd::Graphics::GetInstance()->UnlockDrawContext();

    m_IsIntialized = true;
}

//---------------------------------------------------------------------------
void
Pointer::Finalize()
{
    if ( m_TexImage )
    {
        m_Allocator->Free( m_TexImage );
    }

    m_IsIntialized = false;
}

//---------------------------------------------------------------------------
void
Pointer::Draw( nw::internal::dw::UIRenderer& renderer )
{
    NW_ASSERT( m_IsIntialized );

    const nw::dev::PointerData* pointerData= nw::dev::GetPointerData( m_Type );

    renderer.DrawTexture(
        NULL,
        DrawRectangleArgs().
            SetTexture(&m_Texture).
            SetTopLeft(
                static_cast<f32>(m_Position.x - pointerData->centerX),
                static_cast<f32>(m_Position.y - pointerData->centerY)).
            SetSize(
                static_cast<f32>(nw::dev::POINTER_TEXTURE_SIZE),
                static_cast<f32>(nw::dev::POINTER_TEXTURE_SIZE)).
            SetColor(nw::ut::Color4f::WHITE()));
}

} // namespace nw::internal::dw::detail
} // namespace nw::internal::dw
} // namespace nw::internal
} // namespace nw
