﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_HighestLevelFocusableElementFinder.h>

namespace nw {
namespace internal {
namespace dw {

HighestLevelFocusableElementFinder::HighestLevelFocusableElementFinder() :
m_pResult(NULL),
m_ResultLevel(0),
m_VisibleLevel(0)
{
}

void HighestLevelFocusableElementFinder::Reset()
{
    m_pResult = NULL;
    m_ResultLevel = 0;
    m_VisibleLevel = 0;
}

UIElement* HighestLevelFocusableElementFinder::GetResult() const
{
    return m_pResult;
}

bool HighestLevelFocusableElementFinder::OnCurrentLevelChanged()
{
    u32 currentLevel = GetCurrentLevel();

    if(m_VisibleLevel > currentLevel)
    {
        m_VisibleLevel = currentLevel;
    }

    // 既に候補が見つかっていて、上位層に移動したタイミングで処理を終了します。
    return m_pResult != NULL && m_ResultLevel >= currentLevel;
}

bool HighestLevelFocusableElementFinder::operator ()(UIElement& element)
{
    u32 currentLevel = GetCurrentLevel();

    // 非表示要素はスキップします。
    if(element.GetVisibility() != VISIBLE)
    {
        if(m_VisibleLevel == currentLevel && m_VisibleLevel > 0)
        {
            m_VisibleLevel--;
        }

        return false;
    }

    // 非表示要素の子孫はスキップします。
    if(m_VisibleLevel + 1 < currentLevel)
    {
        return false;
    }

    m_VisibleLevel = currentLevel;

    if(!element.GetIsFocusable())
    {
        return false;
    }

    if(m_pResult == NULL ||
        m_ResultLevel < currentLevel)
    {
        m_pResult = &element;
        m_ResultLevel = currentLevel;
    }

    // さらに下層の候補を検索するために false を返します。
    return false;
}

} // dw
} // internal
} // nw
