﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/cafe/dw_FileBrowserCafe.h>

namespace nw {
namespace internal {
namespace dw {

FileBrowserCafe::FileBrowserCafe()
#if defined(NW_PLATFORM_CAFE)
: m_FsClient(NULL)
, m_FsCmdBlock(NULL)
#endif
{
}

#if defined(NW_PLATFORM_CAFE)
void FileBrowserCafe::Initialize(FSClient* fsClient, FSCmdBlock* fsCmdBlock)
{
    m_FsClient = fsClient;
    m_FsCmdBlock = fsCmdBlock;
}
#endif

void FileBrowserCafe::Finalize()
{
#if defined(NW_PLATFORM_CAFE)
    m_FsClient = NULL;
    m_FsCmdBlock = NULL;
#endif
}

bool FileBrowserCafe::CanMoveParentDirectory(const char* pPath)
{
    NW_NULL_ASSERT(pPath);

    u32 length = strlen(pPath);
    if(length == 0)
    {
        return false;
    }

    // PATH_SEPARATOR が3つ以上見つかったら親ディレクトリへ移動可能とみなします。
    // ただし、最終文字が PATH_SEPARATOR の場合は、4つ以上とします。
    // 移動可能な例   : /vol/pc/C/
    // 移動不可能な例 : /vol/pc, /vol/pc/
    u32 slashCount = 0;
    u32 threshold = pPath[length - 1] == PATH_SEPARATOR ? 4 : 3;
    const char* pCurrent = pPath;

    while(*pCurrent != '\0')
    {
        if(*pCurrent == PATH_SEPARATOR)
        {
            slashCount++;

            if(slashCount >= threshold)
            {
                return true;
            }
        }

        pCurrent++;
    }

    return false;
}

bool FileBrowserCafe::BuildFileEntries(const char* pPath)
{
#if defined(NW_PLATFORM_CAFE)
    // TODO: ファイル列挙をラップし、dev などへ移動する。

    NW_NULL_ASSERT(pPath);

    if ( m_FsClient == NULL || m_FsCmdBlock == NULL )
    {
        return false;
    }

    FSDirHandle handle;
    FSStatus status = FSOpenDir(m_FsClient, m_FsCmdBlock, pPath, &handle, FS_RET_ALL_ERROR);

    if(status < FS_STATUS_OK)
    {
        m_LastError = status;
        return false;
    }

    bool result = true;
    FSDirEntry entry;

    while(true)
    {
        status = FSReadDir(m_FsClient, m_FsCmdBlock, handle, &entry, FS_RET_ALL_ERROR);

        if(status == FS_STATUS_END)
        {
            break;
        }

        if(status < FS_STATUS_OK)
        {
            m_LastError = status;
            result = false;
            break;
        }

        if(!AddFileEntry(
            entry.name,
            (entry.stat.flag & FS_STAT_FLAG_IS_DIRECTORY) != 0))
        {
            break;
        }
    }

    status = FSCloseDir(m_FsClient, m_FsCmdBlock, handle, FS_RET_ALL_ERROR);
    NW_ASSERTMSG(status >= FS_STATUS_OK, "[FileBrowser] failed to FSCloseDir.\n");

    return result;
#else
    (void)pPath;
    return false;
#endif
}

} // dw
} // internal
} // nw
