﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/cafe/dev_WPadDeviceCafe.h>

#if defined(NW_DEV_PAD_ENABLE)

namespace nw
{
namespace dev
{

WPadDeviceCafe* WPadDeviceCafe::s_pInstance = NULL;

//------------------------------------------------------------------------------
void
WPadDeviceCafe::Initialize( nw::ut::IAllocator* /* allocator */ )
{
    if ( m_InitializedCount == 0 )
    {
        // KPADライブラリの初期化
        KPADInitEx(m_UniRingBufs, WPAD_MAX_CONTROLLERS * KPAD_MAX_READ_BUFS);
    }

    ++m_InitializedCount;
}

//------------------------------------------------------------------------------
void
WPadDeviceCafe::Finalize()
{
    --m_InitializedCount;
    if ( m_InitializedCount < 0 )
    {
        m_InitializedCount = 0;
    }

    if ( m_InitializedCount == 0 )
    {
        KPADShutdown();
    }
}

//------------------------------------------------------------------------------
void
WPadDeviceCafe::Update()
{
    for ( int i = 0; i < WPAD_MAX_CONTROLLERS; ++i )
    {
        m_KPadInfos[i].lastReadLength = KPADReadEx(
            i,
            m_KPadInfos[i].status,
            KPAD_MAX_READ_BUFS,
            &m_KPadInfos[i].lastReadError
        );
    }
}

} // namespace dev
} // namespace nw

#endif // NW_DEV_PAD_ENABLE
