﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/cafe/dev_PadDeviceCafe.h>

#if defined(NW_DEV_PAD_ENABLE)

namespace nw
{
namespace dev
{

PadDeviceCafe* PadDeviceCafe::s_pInstance = NULL;

//------------------------------------------------------------------------------
void
PadDeviceCafe::Initialize()
{
    PADInit();

    // m_PADStatuses の初期値を設定
    for( int i = 0; i < PAD_MAX_CONTROLLERS; ++i )
    {
        m_PADStatuses[i].err = PAD_ERR_NO_CONTROLLER;
    }
}

//------------------------------------------------------------------------------
void
PadDeviceCafe::Update()
{
    PADRead( m_PADStatuses );
    PADClampCircle( m_PADStatuses );
}

} // namespace dev
} // namespace nw

#endif // NW_DEV_PAD_ENABLE
