﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/sndspy_SpyData.h>
#include <nw/snd/spy/sndspy_SpyDataID.h>
#include <nw/snd/spy/sndspy_SpyController.h>
#include <nw/snd/spy/modules/sndspy_LogModule.h>
#include <nw/snd/spy/fnd/basis/sndspyfnd_Time.h>
#include <nw/snd/spy/fnd/binary/sndspyfnd_Binary.h>
#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>

namespace {

//! @briefprivate
struct LogPacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 2, 0, 0);
    static const int MESSAGE_MAXLEN = 256;

    char message[MESSAGE_MAXLEN];
};

} // namespace

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
LogModule::LogModule()
    : SpySimpleModule("Log", LogPacketData::VERSION)
{
}

//----------------------------------------------------------
bool
LogModule::WriteFormatV(SpyController& controller, const char* format, va_list arglist)
{
    LogPacketData packet;

    nw::snd::spy::internal::fnd::TimeSpan span = nw::snd::spy::internal::fnd::Time::Current();
    nw::snd::spy::internal::fnd::String::Vsnprintf(packet.message, LogPacketData::MESSAGE_MAXLEN, format, arglist);

    return controller.PushData(controller.GetLogModule(), &packet, sizeof(packet));
}

//----------------------------------------------------------
bool
LogModule::WriteFormatVWithCategory(SpyController& controller, const char* category, const char* format, va_list arglist)
{
    LogPacketData packet;

    nw::snd::spy::internal::fnd::TimeSpan span = nw::snd::spy::internal::fnd::Time::Current();

    int categoryLength = category == NULL ? 0 : strlen(category);

    if ( categoryLength < 0 ) {
        return false;
    }

    if(categoryLength > 0)
    {
        nw::snd::spy::internal::fnd::String::Copy(packet.message, LogPacketData::MESSAGE_MAXLEN, category);
    }

    int restLength = LogPacketData::MESSAGE_MAXLEN - categoryLength;

    if(restLength > 0)
    {
        nw::snd::spy::internal::fnd::String::Vsnprintf(
            packet.message + categoryLength,
            restLength,
            format,
            arglist);
    }

    return controller.PushData(controller.GetLogModule(), &packet, sizeof(packet));
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
