﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/sndedit_SoundArchiveEditController.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/snd_BasicSound.h>
#include <nw/snd/snd_SoundHandle.h>
#include <nw/snd/snd_SoundArchivePlayer.h>
#include <nw/snd/snd_SoundPlayer.h>
#include <nw/snd/fnd/io/sndfnd_FileStream.h>
#include <nw/snd/fnd/string/sndfnd_Path.h>
#include <nw/snd/edit/sndedit_IErrorProvider.h>
#include <nw/snd/edit/sndedit_SoundEditConnection.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
SoundArchiveEditController::SoundArchiveEditController() :
m_ErrorProvider(NULL),
m_Connection(NULL),
m_SoundArchive(NULL),
m_SoundArchivePlayer(NULL),
m_OpenFileBuffer(NULL),
m_OpenFileBufferLength(0),
m_ItemNameBuffer(NULL),
m_ItemNameBufferLength(0),
m_MemoryUsageAtOutOfMemory(0),
m_IsItemInfosOverFlow(false),
m_IsFilesOverFlow(false),
m_IsItemInfoInfoDictionaryInvalid(false),
m_EditItemsChangedCallback(NULL),
m_EditItemsChangedCallbackParam(NULL)
{
}

//----------------------------------------------------------
snd::internal::fnd::FileStream*
SoundArchiveEditController::OpenFile(void* buffer, u32 bufferLength, const char* filePath)
{
    NW_ASSERT_NOT_NULL(filePath);
    NW_ASSERT(*filePath != '\0');

    NW_ASSERTMSG(IsStarted(), "SoundArchiveEditController is not started.\n");

    return m_Connection->OpenFile(buffer, bufferLength, filePath);
}

//----------------------------------------------------------
Result
SoundArchiveEditController::InitializeForPlatform(snd::internal::fnd::FrameHeap& heap)
{
    (void)heap;
    return Result(SNDEDIT_RESULT_TRUE);
}

//----------------------------------------------------------
void
SoundArchiveEditController::FinalizeForPlatform()
{
}

//----------------------------------------------------------
u32
SoundArchiveEditController::GetRequiredMemorySizeForPlatform() const
{
    return 0;
}

//----------------------------------------------------------
snd::internal::fnd::FileStream*
SoundArchiveEditController::OpenFileForCache(void* buffer, u32 bufferLength, const char* filePath)
{
    NW_ASSERT_NOT_NULL(filePath);
    NW_ASSERT(*filePath != '\0');

    NW_ASSERTMSG(IsStarted(), "SoundArchiveEditController is not started.\n");

    return m_Connection->OpenFile(buffer, bufferLength, filePath);
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
