﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/dw/snddw_SoundWindow.h>

#include <string.h>

#include <nw/dw/control/dw_UIElementTreeContext.h>
#include <nw/dw/window/dw_WindowContext.h>

#include <nw/snd/dw/snddw_Config.h>

namespace nw {
namespace snd {
namespace dw {

//------------------------------------------------------------------------------
SoundWindow::SoundWindow()
{
}

//------------------------------------------------------------------------------
SoundWindow::~SoundWindow()
{
}

//------------------------------------------------------------------------------
void
SoundWindow::Initialize(void* memory, u32 memorySize)
{
    m_Allocator.Initialize(memory, memorySize);
    OnInitialize();
}

//------------------------------------------------------------------------------
void
SoundWindow::Finalize()
{
    OnFinalize();
    m_TextRenderer.Finalize();
    m_Allocator.Finalize();
}

//------------------------------------------------------------------------------
void
SoundWindow::Setup(const SetupArg arg)
{
    m_TextRenderer.Initialize(m_Allocator, arg.fontBinary, arg.fontBinarySize, arg.fontShaderBinary, arg.fontShaderBinarySize);

    m_UIRenderer.SetTextRenderer(&m_TextRenderer);
    NW_ASSERT_NOT_NULL(nw::dev::PrimitiveRenderer::GetInstance());
    m_UIRenderer.SetPrimitiveRenderer(nw::dev::PrimitiveRenderer::GetInstance());

    m_UIRenderer.SetProjectionMatrix(*arg.projectionMatrix);
    m_UIRenderer.SetViewMatrix(*arg.viewMatrix);
}

//------------------------------------------------------------------------------
void
SoundWindow::SetTitle(const char* title)
{
    NW_ASSERT(strnlen(title, Window::TITLE_LEN_MAX) < nw::snd::dw::Config::GetInstance().GetWindowTitleLengthMax());
    Window::SetTitle(title);
}

// -----------------------------------------------------------
void
SoundWindow::DrawImpl(nw::internal::dw::WindowContext& context, nw::internal::dw::UIRenderer& renderer, float alpha, bool isShade)
{
    m_UIRenderer.ClearBuffer();

    m_UIRenderer.BeginDraw();

    // ウィンドウフレームの描画
    DrawFrame(context, m_UIRenderer, alpha, isShade);

    // ウィンドウタイトルの描画
    DrawTitle(context, m_UIRenderer, alpha, isShade);

    m_UIRenderer.EndDraw();

    const Window* pPreviousWindow = context.PushWindow(*this, renderer);
    m_UIRenderer.BeginDraw();

    // クライアント領域の描画
    if (!isShade)
    {
        OnDraw( context, m_UIRenderer );
    }

    m_UIRenderer.EndDraw();
    context.PopWindow(pPreviousWindow, renderer);
}

// -----------------------------------------------------------
void*
SoundWindow::Alloc(size_t size, u32 alignment)
{
    if (alignment == 0)
    {
        return m_Allocator.Alloc(size);
    }
    else
    {
        return m_Allocator.Alloc(size, alignment);
    }
}

// -----------------------------------------------------------
void
SoundWindow::Free(void* memory)
{
    m_Allocator.Free(memory);
}

} // namespace dw
} // namespace snd
} // namespace nw
