﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/ctrl/handler/sndctrl_PlaySoundHandler.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/ctrl/sndctrl_SoundObjectController.h>
#include <nw/snd/ctrl/sndctrl_SoundControllerImpl.h>

namespace nw {
namespace snd {
namespace ctrl {
namespace internal {

//----------------------------------------------------------
void
PlaySoundHandler::SetSoundObjectController(SoundObjectController* soundObjectController)
{
    m_SoundObjectController = soundObjectController;
}

//----------------------------------------------------------
edit::internal::HioResult
PlaySoundHandler::OnInvokeForReadTargetPacket(
    const PlaySoundPacket& packet,
    edit::internal::HioPacketStream& /*stream*/)
{
    if(m_SoundObjectController == NULL)
    {
        return edit::internal::HioResult(edit::internal::HIO_RESULT_FALSE);
    }

    if(packet.GetBody().GetItemNameLength() == 0)
    {
        return edit::internal::HioResult(edit::internal::HIO_RESULT_TRUE);
    }

    SoundControllerImpl* controller =
        reinterpret_cast<SoundControllerImpl*>(
        m_SoundObjectController->GetSoundController(packet.GetBody().GetSoundHandleIndex())
        );

    if(controller == NULL)
    {
        return edit::internal::HioResult(edit::internal::HIO_RESULT_TRUE);
    }

    if(controller->SetLabel(packet.GetBody().GetItemName()).IsFailed())
    {
        return edit::internal::HioResult(edit::internal::HIO_RESULT_TRUE);
    }

    controller->Play();

    return edit::internal::HioResult(edit::internal::HIO_RESULT_TRUE);
}

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
