﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_FxBase.h>

#if defined( NW_PLATFORM_WIN32 )
using namespace nw::internal::winext;
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
using namespace nw::internal::winext;
#elif defined( NW_USE_NINTENDO_SDK )
// TODO: nn_audio
using namespace nw::internal::winext;
#endif

namespace nw {
namespace snd {

bool FxBase::Initialize()
{
    return true;
}

void FxBase::Finalize()
{
}

void FxBase::OnChangeOutputMode()
{
}

bool FxBase::IsValidChannelNum( OutputDevice /* device */ )
{
    return true;
}

AXFX_SAMPLE_RATE FxBase::GetFxSampleRate( SampleRate rate )
{
    AXFX_SAMPLE_RATE fxRate = AXFX_SAMPLE_RATE_32000;

    if ( rate == SAMPLE_RATE_32000 )
    {
        fxRate = AXFX_SAMPLE_RATE_32000;
    }
#if defined(NW_SND_CONFIG_ENABLE_SOUND2)
    else if ( rate == SAMPLE_RATE_48000 )
    {
        fxRate = AXFX_SAMPLE_RATE_48000;
    }
#endif

    return fxRate;
}

} // namespace nw::snd
} // namespace nw
