﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/io/sndfnd_HioStream.h>

#include <nw/snd/fnd/basis/sndfnd_Time.h>

#if !defined(NW_PLATFORM_CTR)
#include <nw/ut/ut_String.h>
#endif

namespace {

const u32 READ_TIMEOUT =  30 * 1000;   //!< 読み込みのタイムアウトです。

}

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
HioStream::HioStream()
: m_IsOpened( false )
#if defined(NW_PLATFORM_CAFE)
, m_Channel(NULL)
#else
, m_Channel(0)
#endif
, m_WorkBuffer( NULL )
, m_WorkBufferLength( 0 )
, m_ReadSize( 0 )
#ifdef NW_PLATFORM_CTR
, m_HioWorkBuffer( NULL )
, m_IsConnect( false )
, m_IsRunning( false )
#endif

{
}

//---------------------------------------------------------------------------
HioStream::~HioStream()
{
    this->Close();
}

//---------------------------------------------------------------------------
bool
HioStream::Open(ChannelType channel, void* buffer, u32 length)
{
    NW_NULL_ASSERT(buffer);

    this->Close();

    m_RingBuffer.Init(buffer, length);

    m_Channel = channel;

    OpenImpl(channel);

    return true;
}


//---------------------------------------------------------------------------
void
HioStream::Close()
{
    CloseImpl();

#if defined(NW_PLATFORM_CAFE)
    m_Channel = NULL;
#else
    m_Channel = 0;
#endif
}

//---------------------------------------------------------------------------
s32
HioStream::Read(void* buffer, u32 length)
{
    NW_ASSERT_NOT_NULL( buffer );

    snd::internal::fnd::StopWatch stopWatch;
    stopWatch.Start();
    while(GetReadableBytes() < length)
    {
        if (stopWatch.GetElapsedTime().ToMilliSeconds() >= READ_TIMEOUT)
        {
            stopWatch.Stop();
            NW_LOG("HioStream::Read cannot read buffer\n");
            return 0;
        }
    }

    return m_RingBuffer.Read(buffer, length);
}

//---------------------------------------------------------------------------
s32
HioStream::Peek( void* buffer, u32 length )
{
    NW_ASSERT_NOT_NULL( buffer );

    snd::internal::fnd::StopWatch stopWatch;
    stopWatch.Start();
    while(GetReadableBytes() < length)
    {
        if (stopWatch.GetElapsedTime().ToMilliSeconds() >= READ_TIMEOUT)
        {
            stopWatch.Stop();
            NW_LOG("HioStream::Read cannot peek buffer\n");
            return 0;
        }
    }

    return m_RingBuffer.Peek(buffer, length);
}

//---------------------------------------------------------------------------
s32
HioStream::Skip(u32 length)
{
    snd::internal::fnd::StopWatch stopWatch;
    stopWatch.Start();
    while(GetReadableBytes() < length)
    {
        if (stopWatch.GetElapsedTime().ToMilliSeconds() >= READ_TIMEOUT)
        {
            stopWatch.Stop();
            NW_LOG("HioStream::Skip cannot skip buffer\n");
            return 0;
        }
    }

    return m_RingBuffer.Skip(length);
}

//---------------------------------------------------------------------------
s32
HioStream::Write( const void* buffer, u32 length )
{
    NW_ASSERT_NOT_NULL(buffer);

    s32 result = WriteImpl(buffer, length);

    return result;
}

//---------------------------------------------------------------------------
u32
HioStream::GetReadableBytes()
{
    if ( !IsAvailable() )
    {
        return 0;
    }

    ReadBuffer();

    return m_RingBuffer.GetReadableBytes();
}

//---------------------------------------------------------------------------
u32
HioStream::GetWritableBytes() const
{
    // 未実装（未使用のため）
    NW_ASSERT(false);
    if ( !IsAvailable() )
    {
        return 0;
    }

    return 0;
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
