﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hio.h>
#include <nw/snd/fnd/io/sndfnd_File.h>

#include <nw/snd/fnd/io/sndfnd_FileStream.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

namespace {

//---------------------------------------------------------------------------
bit32
ConvertAccessMode(File::AccessMode accessMode)
{
    switch(accessMode)
    {
    case File::ACCESS_MODE_READ:
        return nn::hio::HostFile::ACCESS_MODE_READ;

    case File::ACCESS_MODE_WRITE:
        return nn::hio::HostFile::ACCESS_MODE_WRITE;

    case File::ACCESS_MODE_READ | File::ACCESS_MODE_WRITE:
        return nn::hio::HostFile::ACCESS_MODE_READ_WRITE;
    }

    return 0;
}

}

//---------------------------------------------------------------------------
FndResult
File::Open(FileStream* stream, const char* filePath, AccessMode accessMode)
{
    NW_NULL_ASSERT(stream);

    bit32 desiredAccess = ConvertAccessMode(accessMode);
    NW_NULL_ASSERT(desiredAccess);

    nn::Result result = stream->Open(filePath, desiredAccess);

    if(result.IsFailure())
    {
        if(result <= nn::fs::ResultNotFound())
        {
            return FndResult(SNDFND_RESULT_IO_FILE_NOT_FOUND);
        }

        return FndResult(SNDFND_RESULT_IO_ERROR);
    }

    return FndResult(SNDFND_RESULT_TRUE);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
