﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/scfont/scfont_Util.h>
#include <nw/scfont/scfont_ScalableFont.h>
#include <nw/lyt/lyt_TextBox.h>

namespace nw
{
namespace scfont
{

u32 RegisterGlyphFromTextBoxRecursive(const lyt::Pane* pane, s32 lockGroup /* = -1 */)
{
    u32 ret = 0;
    const lyt::TextBox* textBox = ut::DynamicCast<const lyt::TextBox*>(pane);
    if (textBox)
    {
        const ScalableFont* font = ut::DynamicCast<const ScalableFont*>(textBox->GetFont());
        if (font)
        {
            ret += font->RegisterGlyphs(textBox->GetString(), lockGroup);
        }
    }

    lyt::PaneList::ConstIterator it_end = pane->GetChildList().GetEndIter();
    for (lyt::PaneList::ConstIterator it = pane->GetChildList().GetBeginIter(); it != it_end; ++it)
    {
        ret += RegisterGlyphFromTextBoxRecursive(&(*it), lockGroup);
    }

    return ret;
}

} // namespace nw::scfont
} // namespace nw
