﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/font/font_ResFont.h>
#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_ResourceAccessor.h>
#include <nw/lyt/lyt_Resources.h>
#include <nw/lyt/lyt_Util.h>
#include <nw/ut/ut_SafeString.h>

namespace nw
{
namespace lyt
{

//----------------------------------------
ResourceAccessor::~ResourceAccessor()
{
}

//----------------------------------------
ResourceAccessor::ResourceAccessor()
{
}

//----------------------------------------
bool
ResourceAccessor::LoadTexture(TextureInfo* textureInfo, const char *name)
{
    u32 size = 0;
    void* pTexRes = this->GetResource(res::RESOURCETYPE_TEXTURE, name, &size);
    if (!pTexRes || size == 0)
    {
        NW_WARNING(false, "texture resource not found. - %s", name);
        return false;
    }

    if (!lyt::LoadTexture(textureInfo, pTexRes, size))
    {
        NW_WARNING(false, "texture object unavailable. - %s", name);
        return false;
    }

    return true;
}

//----------------------------------------
font::Font*
ResourceAccessor::LoadFont(const char *name)
{
    u32 size = 0;
    void* pFontRes = this->GetResource(res::RESOURCETYPE_FONT, name, &size);
    if (!pFontRes || size == 0)
    {
        NW_WARNING(false, "font resource not found. - %s", name);
        return NULL;
    }

    font::ResFont* pResFont = Layout::NewObj<font::ResFont>();
    if (pResFont == NULL)
    {
        NW_WARNING(false, "font object creation failed.");
        return NULL;
    }

    bool bSuccess = pResFont->SetResource(pFontRes);
    if (!bSuccess)
    {
        NW_WARNING(false, "Fail to load ResFont.");
        Layout::DeleteObj(pResFont);
        return NULL;
    }

    return pResFont;
}

//----------------------------------------
bool
ResourceAccessor::LoadShader(ArchiveShaderInfo* pShaderInfo, const char *name)
{
#if defined(NW_PLATFORM_CAFE)
    u32 size = 0;
    nw::ut::FixedSafeString<256> str;
    str.format("lyt_ArchiveShader-%s.bgsh", name);
    void* pShaderRes = this->GetResource(res::RESOURCETYPE_SHADER, str.c_str(), &size);
    if (!pShaderRes || size == 0)
    {
        NW_WARNING(false, "shader resource not found. - %s", name);
        return false;
    }
    return LoadArchiveShader(pShaderInfo, pShaderRes, size, name);
#else
    NW_UNUSED_VARIABLE(pShaderInfo);
    NW_UNUSED_VARIABLE(name);
    return false;
#endif
}

} // namespace nw::lyt
} // namespace nw
