﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/font/font_ResFont.h>
#include <nw/lyt/lyt_FontContainer.h>
#include <nw/lyt/lyt_Layout.h>
#include <nw/ut/ut_String.h>

namespace nw
{
namespace lyt
{

FontRefLink::FontRefLink()
:   m_pFont(0),
    m_Own(false)
{
}

FontRefLink::~FontRefLink()
{
    if (m_Own)
    {
        Layout::DeleteObj(m_pFont);
        m_pFont = NULL;
    }
}

void
FontRefLink::Set(
    const char* name,
    font::Font* pFont,
    bool own
)
{
    ut::strcpy(m_FontName, sizeof(m_FontName), name);
    m_pFont = pFont;
    m_Own = own;
}

FontContainer::~FontContainer()
{
    this->Finalize();
}

void
FontContainer::Finalize()
{
    while (!this->empty())
    {
        FontRefLink* pLink = &this->front();
        this->erase(pLink);
        Layout::DeleteObj(pLink);
    }
}

nw::font::Font*
FontContainer::FindFontByName(
    const char* name
)
{
    Iterator it_end = this->GetEndIter();
    for (Iterator it = this->GetBeginIter(); it != it_end; ++it)
    {
        if (internal::EqualsFontName(name, it->GetFontName()))
        {
            return it->GetFont();
        }
    }

    return NULL;
}

FontKey
FontContainer::RegistFont(const char* name, font::Font* pFont, bool own)
{
    FontRefLink* pLink = Layout::NewObj<FontRefLink>();

    if (pLink == NULL)
    {
        return NULL;
    }

    pLink->Set(name, pFont, own);

    this->push_back(pLink);

    return reinterpret_cast<FontKey>(pLink);
}

void
FontContainer::UnregistFont(FontKey key)
{
    NW_ASSERT_NOT_NULL(key);

    FontRefLink* pLink = (FontRefLink*)(key);
    this->erase(pLink);
    Layout::DeleteObj(pLink);
}

}   // namespace lyt
}   // namespace nw
