﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Bounding.h>
#include <nw/lyt/lyt_DrawInfo.h>
#include <nw/lyt/lyt_GraphicsResource.h>
#include <nw/lyt/lyt_ResourceAccessor.h>
#include <nw/lyt/lyt_Resources.h>

namespace nw
{
namespace lyt
{

using namespace math;

Bounding::Bounding(
    const res::Bounding* pBaseBlock,
    const res::Bounding* pOverrideBlock,
    const BuildArgSet& buildArgSet
)
: Base(pBaseBlock, buildArgSet)
{
    NW_UNUSED_VARIABLE(pOverrideBlock)
}

Bounding::Bounding(const Bounding& bounding)
 : Base(bounding)
{
}

Bounding::~Bounding()
{
    // OSReport("Bounding::~Bounding()\n");
}

void
Bounding::DrawSelf(DrawInfo& drawInfo)
{
    NW_UNUSED_VARIABLE(drawInfo)
}

} // namespace nw::lyt
} // namespace nw
