﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSERROR_H_
#define NW_WINEXT_OSERROR_H_

#include <winext/cafe/os.h>

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
    Error Handler API
 *---------------------------------------------------------------------------*/

typedef u16    OSError;

/*
 * Note: for most errors, OSErrorHandler takes third and fourth arguments
 * /dsisr/ and /dar/, which are of type /u32/ like below:
 *
 * void (*OSErrorHandler)( OSError error, OSContext* context,
 *                         u32 dsisr, u32 dar );
 *
 */

#define OS_ERROR_SYSTEM_RESET         0
#define OS_ERROR_MACHINE_CHECK        1
#define OS_ERROR_DSI                  2
#define OS_ERROR_ISI                  3
#define OS_ERROR_EXTERNAL_INTERRUPT   4
#define OS_ERROR_ALIGNMENT            5
#define OS_ERROR_PROGRAM              6
#define OS_ERROR_FLOATING_POINT       7     // floating-point unavailable
#define OS_ERROR_DECREMENTER          8
#define OS_ERROR_SYSTEM_CALL          9
#define OS_ERROR_TRACE                10
#define OS_ERROR_PERFORMACE_MONITOR   11
#define OS_ERROR_BREAKPOINT           12
#define OS_ERROR_SYSTEM_INTERRUPT     13
#define OS_ERROR_THERMAL_INTERRUPT    14
#define OS_ERROR_PROTECTION           15
#define OS_ERROR_FPE                  16    // floating-point exception

#define OS_ERROR_MAX                  (OS_ERROR_FPE+1)

u32  OSGetLastError( void );

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSERROR_H_
