﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_MEM_ARENA_H_INCLUDED_
#define NW_WINEXT_MEM_ARENA_H_INCLUDED_

#include <winext/cafe/mem/heapCommon.h>

namespace nw {
namespace internal {
namespace winext {

// These are logical not physical.  For flexibility, may not be a one-to-one
// mapping to physical devices such as MEM1/MEM2. For example, at OS-level
// we could split physical MEM2 into disjoint logical arenas to present to
// the application.
typedef enum MEMArena {
    MEM_ARENA_1,            // MEM1
    MEM_ARENA_2,            // MEM2
    MEM_ARENA_3,
    MEM_ARENA_4,
    MEM_ARENA_5,
    MEM_ARENA_6,
    MEM_ARENA_7,
    MEM_ARENA_8,
    MEM_ARENA_FG,           // Foreground bucket
    MEM_ARENA_MAX,
    MEM_ARENA_INVALID       // invalid arena id
} MEMArena;

// Private functions.  Remove from public later.
void          MEMInitArenaLibrary (void);

// Public functions.
MEMHeapHandle MEMGetBaseHeapHandle (MEMArena arena);
MEMHeapHandle MEMSetBaseHeapHandle (MEMArena arena, MEMHeapHandle heap);
MEMArena      MEMGetArena (MEMHeapHandle heap);

} // namespace winext
} // namespace internal
} // namespace nw

#endif  /* NW_WINEXT_MEM_ARENA_H_INCLUDED_ */
