﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_MEM_ALLOCATOR_H_
#define NW_WINEXT_MEM_ALLOCATOR_H_



#include <winext/cafe/mem/heapCommon.h>

namespace nw {
namespace internal {
namespace winext {

/* ========================================================================
    型定義
   ======================================================================== */

typedef struct MEMAllocator MEMAllocator;

typedef void* (*MEMFuncAllocatorAlloc)( MEMAllocator* pAllocator, u32 size );

typedef void  (*MEMFuncAllocatorFree) ( MEMAllocator* pAllocator, void* memBlock );

typedef struct MEMAllocatorFunc MEMAllocatorFunc;

struct MEMAllocatorFunc
{
    MEMFuncAllocatorAlloc    pfAlloc;
    MEMFuncAllocatorFree     pfFree;
};

struct MEMAllocator
{
    MEMAllocatorFunc const *  pFunc;
    void*                     pHeap;
    u32                       heapParam1;
    u32                       heapParam2;
};


/* ========================================================================
    関数プロトタイプ
   ======================================================================== */

void*       MEMAllocFromAllocator( MEMAllocator* pAllocator, u32 size );

void        MEMFreeToAllocator   ( MEMAllocator* pAllocator, void* memBlock );

void        MEMInitAllocatorForExpHeap(
                    MEMAllocator*    pAllocator,
                    MEMHeapHandle    heap,
                    int              alignment );

void        MEMInitAllocatorForFrmHeap(
                    MEMAllocator*    pAllocator,
                    MEMHeapHandle    heap,
                    int              alignment );

void        MEMInitAllocatorForUnitHeap( MEMAllocator* pAllocator, MEMHeapHandle heap );

void        MEMInitAllocatorForDefaultHeap ( MEMAllocator* pAllocator );

#if 0
void        MEMInitAllocatorForBlockHeap ( MEMAllocator* pAllocator, MEMHeapHandle heap, int alignment);
#endif

} // namespace winext
} // namespace internal
} // namespace nw

/* NW_WINEXT_MEM_ALLOCATOR_H_ */
#endif
