﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_UT_SCOPED_LOCK_H_
#define NW_UT_SCOPED_LOCK_H_

#include <nw/types.h>
#include <nw/ut/ut_Preprocessor.h>

namespace nw {
namespace ut {

//---------------------------------------------------------------------------
//! @brief        スコープ内でのみ、ロックをおこなうクラスです。
//---------------------------------------------------------------------------
template<typename TLockObject>
class ScopedLock
{
private:
    NW_DISALLOW_COPY_AND_ASSIGN(ScopedLock);

public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタでロックを行います。
    //!
    //! @param[out]   lockObj 使用するロックオブジェクトです。
    //---------------------------------------------------------------------------
    /* ctor */ explicit ScopedLock(TLockObject& lockObj) : m_LockObj(lockObj)
    {
        m_LockObj.Lock();
    }

    //---------------------------------------------------------------------------
    //! @brief        デストラクタでアンロックをおこないます。
    //---------------------------------------------------------------------------
    ~ScopedLock()
    {
        m_LockObj.Unlock();
    }

private:
    TLockObject& m_LockObj;
};

} // namespace ut
} // namespace nw

#endif //  NW_UT_SCOPED_LOCK_H_
