﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snddw.h
 *
 * @file snddw.h
 */

#ifndef NW_SND_DW_H_
#define NW_SND_DW_H_

//---------------------------------------------------------------------------
//! @namespace nw::snd::dw
//!
//! @brief    サウンドデバッグウィンドウライブラリの名前空間です。
//!
//!           サウンドデバッグウィンドウを利用することで、
//!           - Voiceの数やボリューム
//!           - サウンドスレッドのパフォーマンス
//!           - 波形出力のタイムライン表示
//!           を手軽に確認することができます。
//!
//!           なお、サウンドデバッグウィンドウライブラリを利用するには、
//!           libnw4f_snddev.a を別途リンクする必要があります。
//!
//!           詳しい使用方法などはサンプルデモを参照してください。
//!
//! @date 2012/02/17 初版
//!
//---------------------------------------------------------------------------

#include <nw/snd/dw/snddw_SoundWindowSystem.h>
#include <nw/snd/dw/snddw_VoicesWindow.h>
#include <nw/snd/dw/snddw_PerformanceWindow.h>
#include <nw/snd/dw/snddw_MasterOutputWindow.h>
#include <nw/snd/dw/snddw_VoicesPanel.h>
#include <nw/snd/dw/snddw_PerformancePanel.h>
#include <nw/snd/dw/snddw_MasterOutputPanel.h>

#endif /* NW_SND_DW_H_ */

