﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_PACKET_READER_H_
#define NW_SND_SPY_SPY_PACKET_READER_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/fnd/hio/sndspyfnd_HioChannel.h>
#include <nw/snd/spy/protocol/sndspy_Packet.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {

struct PacketBase;

class SpyPacketReader
{
public:
    enum State
    {
        STATE_NOT_INITIALIZED,
        STATE_IDLE,
        STATE_READING_HEADER,
        STATE_READ_HEADER,
        STATE_READING_BODY,
        STATE_READ_BODY
    };

public:
    SpyPacketReader();

public:
    void Initialize(nw::snd::spy::internal::fnd::HioChannel* channel, void* buffer);
    void Finalize();

    bool IsInitialized() const { return m_State > STATE_NOT_INITIALIZED; }

    bool ReadPacketHeader();

    bool ReadPacketBody(void* buffer, u32 length);

    void Next();

    State GetState() const { return m_State; }
    bool  CanReadHeader() const { return m_State == STATE_IDLE; }

    const PacketHeader* GetCurrentPacketHeader() const
    {
        return m_ReadPacketLength >= sizeof(PacketHeader) ? m_PacketHeader : NULL;
    }

private:
    static const char* StateToString(State value);

private:
    nw::snd::spy::internal::fnd::HioChannel* m_Channel;

    State         m_State;
    PacketHeader* m_PacketHeader;
    u32           m_ReadPacketLength;
};

} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_SPY_PACKET_READER_H_
