﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_DATA_H_
#define NW_SND_SPY_SPY_DATA_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/fnd/binary/sndspyfnd_Binary.h>
#include <nw/snd/spy/sndspy_SpyDataID.h>

namespace nw {
namespace snd {
namespace spy {

class SpyController;

//! @briefprivate
struct VoiceInfoPacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);

    //! @briefprivate
    struct VoiceInfo
    {
        u8 index;
        u8 status;
        u16 padding1[1];
        f32 volume;
        f32 pitch;
        f32 mainMixLeft;
        f32 mainMixRight;
        f32 drcMixLeft;
        f32 drcMixRight;
    };

    static const int VOICE_COUNT_MAX = 96;

    u32 audioFrame;
    u32 arraySize;
    VoiceInfo voiceInfo[VOICE_COUNT_MAX];
};

//! @briefprivate
struct ProfilePacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);

    u32 audioFrame;
    u32 voiceCount;
    s64 nwFrameProcessBegin;
    s64 nwFrameProcessEnd;
    s64 nwVoiceParamUpdateBegin;
    s64 nwVoiceParamUpdateEnd;
    s64 ppcVoiceRenderingBegin;
    s64 ppcVoiceRenderingEnd;
    s64 auxProcessBegin;
    s64 auxProcessEnd;
    s64 dspFrameProcessBegin;
    s64 dspFrameProcessEnd;
    s64 syncVoiceParamBegin;
    s64 syncVoiceParamEnd;
    s64 outputFormatProcessBegin;
    s64 outputFormatProcessEnd;
    s64 mainMixProcessBegin;
    s64 mainMixProcessEnd;
    s64 finalMixProcessBegin;
    s64 finalMixProcessEnd;
    s64 axIntrBegin;
    s64 axIntrEnd;
};

//! @briefprivate
struct FinalOutPacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);

    static const int MAX_CHANNELS = 6;
    static const int SAMPLES_PER_FRAME = 144;
    static const int MAX_DEVICES = 3;
    static const int MAX_SAMPLES = MAX_CHANNELS * SAMPLES_PER_FRAME * MAX_DEVICES;

    enum ChanelBitFlag
    {
        CHANNEL_BIT_FRONT_LEFT = (1<<0),
        CHANNEL_BIT_FRONT_RIGHT = (1<<1),
        CHANNEL_BIT_REAR_LEFT = (1<<2),
        CHANNEL_BIT_REAR_RIGHT = (1<<3),
        CHANNEL_BIT_FRONT_CENTER = (1<<4),
        CHANNEL_BIT_LFE = (1<<5),
        CHANNEL_BIT_DRC_LEFT = (1<<6),
        CHANNEL_BIT_DRC_RIGHT = (1<<7),
    };

    u32 audioFrame;
    u32 channelBitFlag;
    u32 samplePerFrame;
    s16 finalOutput[MAX_SAMPLES];
};

//! @briefprivate
struct SoundStatusInfoPacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);
    static const int MAX_SOUND_INFO = 1024;

    static const u8 STATUS_START = (1 << 0);
    static const u8 STATUS_PAUSE = (1 << 1 );
    static const u8 STATUS_PREPARED = (1 << 2 );

    //! @briefprivate
    struct SoundInfo
    {
        u32 instanceId;
        u32 soundId;
        u8 statusBitFlag;
        u8 padding1[3];
    };

    u32 soundCount;
    SoundInfo soundInfoArray[MAX_SOUND_INFO];
};

//! @briefprivate
struct PString
{
    u8 len;
    char str[255];

    void Assign( const char* str );
};

//! @briefprivate
struct SoundDataInfoPacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);
    static const int ITEM_AREA_SIZE = 1024;

    enum ItemType
    {
        ITEM_TYPE_SOUND = 0,
        ITEM_TYPE_PLAYER = 1
    };

    enum SoundType
    {
        SOUND_TYPE_SEQUENCE = 0,
        SOUND_TYPE_WAVE = 1,
        SOUND_TYPE_STREAM = 2
    };

    //! @briefprivate
    struct SoundInfo
    {
        u32 soundId;
        u32 playerId;

        u8 soundType;
        u8 volume;
        u8 playerPriority;
        u8 padding1[1];

        PString label;
    };

    //! @briefprivate
    struct PlayerInfo
    {
        u32 playerId;

        PString label;
    };

    u32 itemType;
    u32 itemCount;
    u32 itemArea[ ITEM_AREA_SIZE / sizeof(u32) ];
};

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_SPY_DATA_H_
