﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_PLOT_MODULE_H_
#define NW_SND_SPY_SPY_PLOT_MODULE_H_

#include <nw/snd/spy/modules/sndspy_SpyModule.h>

#include <nw/snd/spy/sndspy_Config.h>

namespace nw {
namespace snd {
namespace spy {

class SpyController;
class PlotGroup;
class PlotItem;
class PlotState;

#ifdef NW_SND_SPY_ENABLE

//! @briefprivate
class PlotModule : public SpySimpleModule
{
public:
    PlotModule();

    bool AttachItem(PlotItem& item);
    void DetachItem(PlotItem& item);

    bool AttachState(PlotState& state);
    void DetachState(PlotState& state);

    bool AttachGroup(PlotGroup& group);
    void DetachGroup(PlotGroup& group);

protected:
    virtual void OnSessionStarted();
    virtual void OnRequested(bool isRequested);

private:
    void PushGroupMetadata(PlotGroup* pGroup);

    bool PushData(const void* buffer, u32 length);

    template <typename T>
    bool PushData(const T& data)
    {
        return PushData(&data, sizeof(T));
    }

private:
    PlotItem* m_ItemTop;
    PlotItem* m_ItemLast;

    PlotState* m_StateTop;
    PlotState* m_StateLast;

    PlotGroup* m_GroupTop;
    PlotGroup* m_GroupLast;

    bool m_IsMetadataPushed;
    bool m_IsResetPushed;

    friend class PlotGroup;
    friend class PlotItem;
    friend class PlotState;
};

#endif // NW_SND_SPY_ENABLE

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_SPY_PLOT_MODULE_H_
