﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_MARKER_PACKET_H_
#define NW_SND_SPY_SPY_MARKER_PACKET_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/modules/sndspy_PacketUtility.h>
#include <nw/snd/spy/modules/sndspy_MarkerTraits.h>

namespace nw {
namespace snd {
namespace spy {

//! @briefprivate
class MarkerPacket
{
public:
    static const u32 PACKET_VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(1, 0, 0, 0);

    //! @briefprivate 値パケット
    struct ValuePacketPayload
    {
        u32 id;             ///< アイテムID

        ColorData color;
        StringData<u8, MarkerTraits::MAX_DESCRIPTION_LENGTH> description;
    };
};

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_SPY_MARKER_ITEM_PACKET_H_
