﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_HIO_INITIALIZER_H_
#define NW_SND_SPY_FND_HIO_INITIALIZER_H_

#include "../../sndspy_Config.h"
#ifdef NW_SND_SPY_ENABLE

#if defined(NW_PLATFORM_CAFE)
#include <cafe/hio.h>
#endif

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief    HIO の初期化をサポートします。
//---------------------------------------------------------------------------
class HioInitializer
{
private:
    HioInitializer() { }

public:
    //! @brief 初期化します。
    static void Initialize();

    //! @brief 終了します。
    static void Finalize();

private:
    static u32 m_Count;     //!< 初期化回数です。
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_FND_HIO_INITIALIZER_H_
