﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_ALIGNMENT_H_
#define NW_SND_SPY_FND_ALIGNMENT_H_

#include <nw/snd/spy/fnd/basis/sndspyfnd_Inlines.h>
#include <nw/snd/spy/fnd/basis/sndspyfnd_Config.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

template<typename TValue, u32 Alignment>
class AlignedValue
{
public:
    AlignedValue()
    {
        new(&GetValue()) TValue();
    }

    const TValue& GetValue() const
    {
        return *static_cast<const TValue*>(ut::RoundUp(m_Buffer, Alignment));
    }

    TValue& GetValue()
    {
        return *static_cast<TValue*>(ut::RoundUp(m_Buffer, Alignment));
    }

private:
    u8 m_Buffer[sizeof(TValue) + Alignment];
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_FND_ALIGNMENT_H_
