﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_WAVE_SOUND_H_
#define NW_SND_WAVE_SOUND_H_

#include <nw/snd/snd_BasicSound.h>
#include <nw/snd/snd_WaveSoundPlayer.h>
#include <nw/snd/snd_SoundInstanceManager.h>
#include <nw/snd/snd_Debug.h>
#include <nw/snd/snd_Task.h>

namespace nw {
namespace snd {

/* ========================================================================
        type declarataion
   ======================================================================== */

class WaveSoundHandle;

/* ========================================================================
        class definition
   ======================================================================== */

namespace internal {

class WaveSound;

typedef SoundInstanceManager<WaveSound> WaveSoundInstanceManager;

class WaveSound : public BasicSound
{
    friend class nw::snd::WaveSoundHandle;

public:
    NW_UT_RUNTIME_TYPEINFO(BasicSound)

    /* ------------------------------------------------------------------------
            class member
       ------------------------------------------------------------------------ */
public:
    explicit WaveSound( WaveSoundInstanceManager& manager );

    void Prepare(
            const driver::WaveSoundPlayer::StartInfo& info,
            const driver::WaveSoundPlayer::PrepareArg& arg);

    void RegisterDataLoadTask(
            const driver::WaveSoundLoader::LoadInfo& loadInfo,
            const driver::WaveSoundPlayer::StartInfo& startInfo );

    /* override */ void Initialize();
    /* override */ void Finalize();
    /* override */ bool IsPrepared() const
    {
        if ( m_IsCalledPrepare ) return true;

        if (!IsPlayerAvailable()) return false;
        return m_PlayerInstance.IsPrepared();
    }

    // パラメータ設定
    void InitializeChannelParam(int priority, bool isReleasePriorityFix);
    void SetChannelPriority( int priority );

    // パラメータ取得
    bool ReadWaveSoundDataInfo( WaveSoundDataInfo* info ) const;
    long GetPlaySamplePosition(bool isOriginalSamplePosition) const;
    NW_INLINE u32 GetChannelCount() const { return m_ChannelCount; }

    void SetLoaderManager(driver::WaveSoundLoaderManager& manager)
    {
        m_PlayerInstance.SetLoaderManager(&manager);
    }

    // デバッグ関数
    DebugSoundType GetSoundType() const { return DEBUG_SOUND_TYPE_WAVESOUND; }

private:
    /* override */ bool IsAttachedTempSpecialHandle();
    /* override */ void DetachTempSpecialHandle();
    /* override */ void OnUpdatePlayerPriority();

    /* override */ void OnUpdateParam() {} // あとで消す
    /* override */ driver::BasicSoundPlayer* GetBasicSoundPlayerHandle()
    {
        return &m_PlayerInstance;
    }

    WaveSoundHandle* m_pTempSpecialHandle;
    WaveSoundInstanceManager& m_Manager;

    const void* m_pWaveFile;
    s8 m_WaveType;
    bool m_InitializeFlag;
    bool m_IsCalledPrepare; // Prepare() が呼ばれたかどうか
    u8 padding[1];
    u32 m_ChannelCount;

    driver::WaveSoundPlayer m_PlayerInstance;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_WAVE_SOUND_H_ */

