﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SEQUENCE_SOUND_FILE_H_
#define NW_SND_SEQUENCE_SOUND_FILE_H_

#if defined(NW_PLATFORM_CAFE)
#include <nw/ut/ut_BinaryFileFormat.h>
#else
#include <nw/snd/snd_BinaryFileFormat.h>
#endif
#include <nw/snd/snd_Util.h>

namespace nw {
namespace snd {
namespace internal {

struct SequenceSoundFile
{
    //-----------------------------------------------------------------
    // ファイルヘッダー

    struct DataBlock;
    struct LabelBlock;

    struct FileHeader : public Util::SoundFileHeader
    {
        const DataBlock* GetDataBlock() const;
        const LabelBlock* GetLabelBlock() const;
    };

    //-----------------------------------------------------------------
    // データブロック

    struct DataBlockBody
    {
        u8 sequenceData[1];
        const void* GetSequenceData() const { return reinterpret_cast<const void*>(sequenceData); }
    };

    struct DataBlock
    {
        ut::BinaryBlockHeader   header;
        DataBlockBody           body;
    };

    //-----------------------------------------------------------------
    // ラベルブロック

    struct LabelInfo;
    struct LabelBlockBody
    {
        // データ
        Util::ReferenceTable labelInfoReferenceTable;

        // アクセサ
        inline int GetLabelCount() const { return labelInfoReferenceTable.count; }
        const LabelInfo* GetLabelInfo( int index ) const;
        const char* GetLabel( int index ) const;
        const char* GetLabelByOffset( u32 offset ) const;
        bool GetOffset( int index, u32* offsetPtr ) const;
        bool GetOffsetByLabel( const char* label, u32* offsetPtr ) const;
    };

    struct LabelBlock
    {
        ut::BinaryBlockHeader   header;
        LabelBlockBody          body;           // ラベルデータ本体
    };

    struct LabelInfo
    {
        Util::Reference referToSequenceData;    // DataBlockBody を基点とするリファレンス
#if defined(NW_PLATFORM_CAFE)
        ut::ResU32 labelStringLength;           // ラベル文字列の長さ
#else
        u32 labelStringLength;                  // ラベル文字列の長さ
#endif
        char label[1];
    };

};


} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_SEQUENCE_SOUND_FILE_H_ */

