﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_MML_SEQUENCE_TRACK_H_
#define NW_SND_MML_SEQUENCE_TRACK_H_

#include <nw/snd/snd_SequenceTrack.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

class MmlParser;

/* ========================================================================
        class definition
   ======================================================================== */

class MmlSequenceTrack : public SequenceTrack
{
public:
    MmlSequenceTrack();

    void SetMmlParser( const MmlParser* parser ) { m_pParser = parser; }
    const MmlParser* GetMmlParser() const { return m_pParser; }

protected:
    virtual SequenceTrack::ParseResult Parse( bool doNoteOn );

private:
    const MmlParser* m_pParser;
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_MML_SEQUENCE_TRACK_H_ */

