﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_MIDI_SEQUENCE_TRACK_ALLOCATOR_H_
#define NW_SND_MIDI_SEQUENCE_TRACK_ALLOCATOR_H_

#include <nw/snd/snd_SequenceTrackAllocator.h>
#include <nw/snd/snd_MidiSequenceTrack.h>
#include <nw/snd/snd_InstancePool.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

/* ========================================================================
        class difinition
   ======================================================================== */

class MidiSequenceTrackAllocator : public SequenceTrackAllocator
{
public:
    MidiSequenceTrackAllocator() {}

    virtual SequenceTrack* AllocTrack( SequenceSoundPlayer* player );
    virtual void FreeTrack( SequenceTrack* track );
    virtual int GetAllocatableTrackCount() const;

    unsigned long Create( void* buffer, unsigned long size );
    void Destroy();

private:
    InstancePool<MidiSequenceTrack> m_TrackPool;
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_MIDI_SEQUENCE_TRACK_ALLOCATOR_H_ */

