﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_GROUP_FILE_READER_H_
#define NW_SND_GROUP_FILE_READER_H_

#include <nw/snd/snd_GroupFile.h>

namespace nw {
namespace snd {
namespace internal {

struct GroupItemLocationInfo
{
    u32 fileId;
    const void* address;    // 非 NULL: 埋め込みアイテム。ロードされたアドレスを格納。
                            // NULL   : リンクアイテム。別途ロードが必要。
};

class GroupFileReader
{
public:
    static const u32 SIGNATURE_FILE = NW_UT_MAKE_SIGWORD( 'F', 'G', 'R', 'P' );

    explicit GroupFileReader( const void* groupFile );

    // InfoBlock の情報を取得
    u32 GetGroupItemCount() const { return m_pInfoBlockBody->GetGroupItemInfoCount(); }
    bool ReadGroupItemLocationInfo( GroupItemLocationInfo* out, u32 index ) const;

    // InfoExBlock の情報を取得
    u32 GetGroupItemExCount() const;
    bool ReadGroupItemInfoEx( GroupFile::GroupItemInfoEx* out, u32 index ) const;

private:
    const GroupFile::InfoBlockBody* m_pInfoBlockBody;
    const GroupFile::FileBlockBody* m_pFileBlockBody;
    const GroupFile::InfoExBlockBody* m_pInfoExBlockBody;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_GROUP_FILE_READER_H_ */

